
local cfg = {}

-- example of study transformer
local transformer_study = {
  title="Bookcase", -- menu name
  color={0,255,0}, -- color
  max_units=20,
  units_per_minute=10,
  position = {0,0,0}, -- doesn't matter as home component
  radius=1.1, height=1.5, -- area
  recipes = {
    ["Chemicals book"] = { -- action name
      description="Read a chemicals book", -- action description
      reagents={}, -- items taken per unit
      products={
        aptitudes={
          ["science.chemicals"] = 1 -- "group.aptitude", give 1 exp per unit
        }
      }
    },
    ["Mathematics book"] = { -- action name
      description="Read a mathematics book", -- action description
      reagents={}, -- items taken per unit
      products={
        aptitudes={
          ["science.mathematics"] = 1 -- "group.aptitude", give 1 exp per unit
        }
      }
    }
  }
}

-- example of radio stations
local radio_stations = {
  ["TechnoBase.FM"] = "http://mp3.stream.tb-group.fm:80/tt.ogg",
  ["Phate Radio"] = "http://phate.io/listen.ogg",
  ["RADIO 1 ROCK"] = "http://stream.radioreklama.bg:80/radio1rock.ogg",
  ["R 247drumandbass.com"] = "http://stream.247drumandbass.com:8000/256k.ogg"
}

-- default flats positions from https://github.com/Nadochima/HomeGTAV/blob/master/List

-- define the home slots (each entry coordinate should be unique for ALL types)
-- each slots is a list of home components
--- {component,x,y,z} (optional _config)
--- the entry component is required
cfg.slot_types = {
  ["basic_flat"] = {
    {
      {"entry",-782.171,324.589,223.258},
      {"chest",-773.718078613281,325.144409179688,223.266357421875, _config = {weight=200}},
      {"wardrobe",-760.885437011719,325.457153320313,217.061080932617},
      {"gametable",-755.40185546875,318.263214111328,221.875823974609},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -758.670104980469,315.048156738281,221.854904174805},
      {"radio", -755.68768310547,331.09976196289,221.85510253906, _config = { stations = radio_stations }}
    },
    {
      {"entry",-774.171,333.589,207.621},
      {"chest",-782.118591308594,332.147399902344,207.629608154297, _config = {weight=200}},
      {"wardrobe",-795.118469238281,331.631256103516,201.42431640625},
      {"gametable",-800.763427734375,338.574951171875,206.239105224609},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -797.283447265625,342.134338378906,206.21842956543},
      {"radio", -800.40148925781,326.16177368164,206.21821594238, _config = { stations = radio_stations }}
    },
    {
      {"entry",-774.171,333.589,159.998},
      {"chest",-782.66015625,332.523284912109,160.010223388672, _config = {weight=200}},
      {"wardrobe",-795.550964355469,332.229614257813,153.804931640625},
      {"gametable",-801.228942871094,339.106231689453,158.619750976563},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -797.896728515625,342.543273925781,158.599044799805},
      {"radio", -800.87060546875,326.45428466797,158.59884643555, _config = { stations = radio_stations }}
    },
    {
      {"entry",-596.689,59.139,108.030},
      {"chest",-604.427001953125,57.0807762145996,108.035743713379, _config = {weight=200}},
      {"wardrobe",-617.180358886719,56.9536590576172,101.830520629883},
      {"gametable",-623.078796386719,63.688045501709,106.645317077637},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -619.724853515625,67.1367950439453,106.624366760254},
      {"radio", -622.71990966797,51.135990142822,106.62439727783, _config = { stations = radio_stations }}
    },
    {
      {"entry",-1451.557,-523.546,69.556},
      {"chest",-1457.28601074219,-529.699523925781,69.565315246582, _config = {weight=200}},
      {"wardrobe",-1467.07995605469,-536.98583984375,63.3601188659668},
      {"gametable",-1476.12658691406,-534.873474121094,68.1748962402344},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -1475.36840820313,-530.117126464844,68.1540756225586},
      {"radio", -1468.7071533203,-545.08715820313,68.153968811035, _config = { stations = radio_stations }}
    },
    {
      {"entry",-1452.185,-522.640,56.929},
      {"chest",-1457.3740234375,-529.737854003906,56.9376449584961, _config = {weight=200}},
      {"wardrobe",-1467.7158203125,-537.308349609375,50.732494354248},
      {"gametable",-1476.12670898438,-534.895751953125,55.547306060791},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -1475.39453125,-530.135192871094,55.5264129638672},
      {"radio", -1468.6722412109,-545.06427001953,55.526348114014, _config = { stations = radio_stations }}
    },
    {
      {"entry",-907.900,-370.608,109.440},
      {"chest",-914.79296875,-375.26416015625,109.448974609375, _config = {weight=200}},
      {"wardrobe",-926.047912597656,-381.470153808594,103.243774414063},
      {"gametable",-934.216979980469,-378.082336425781,108.05859375},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -932.810302734375,-373.413330078125,108.03776550293},
      {"radio", -928.19958496094,-389.09826660156,108.03771972656, _config = { stations = radio_stations }}
    },
    {
      {"entry",-921.124,-381.099,85.480},
      {"chest",-915.268737792969,-375.818084716797,85.4891815185547, _config = {weight=200}},
      {"wardrobe",-904.0673828125,-369.910552978516,79.2839508056641},
      {"gametable",-895.890075683594,-373.167846679688,84.0987701416016},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -897.224792480469,-377.828887939453,84.0779266357422},
      {"radio", -901.92596435547,-362.20422363281,84.077835083008, _config = { stations = radio_stations }}
    },
    {
      {"entry",-464.453,-708.617,77.086},
      {"chest",-466.566558837891,-700.528991699219,77.0956268310547, _config = {weight=200}},
      {"wardrobe",-466.892852783203,-687.88720703125,70.8903503417969},
      {"gametable",-459.870513916016,-682.054565429688,75.7051773071289},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -456.510467529297,-685.274841308594,75.6842498779297},
      {"radio", -472.61911010742,-682.53247070313,75.684257507324, _config = { stations = radio_stations }}
    },
    {
      {"entry",-470.647,-689.459,53.402},
      {"chest",-469.077453613281,-697.664672851563,53.4144515991211, _config = {weight=200}},
      {"wardrobe",-468.939910888672,-710.398986816406,47.2093048095703},
      {"gametable",-475.543884277344,-716.226867675781,52.0241050720215},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -479.113037109375,-712.874938964844,52.0032043457031},
      {"radio", -463.13302612305,-715.83905029297,52.003196716309, _config = { stations = radio_stations }}
    }
  },
  ["rich_flat"] = {
    {
      {"entry",-784.363,323.792,211.996},
      {"chest",-766.744384765625,328.375,211.396545410156, _config = {weight=500}},
      {"wardrobe",-793.502136230469,326.861846923828,210.796630859375},
      {"gametable",-781.973083496094,338.788482666016,211.231979370117},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -778.560241699219,333.439453125,211.197128295898},
      {"radio", -786.3671875,337.87127685547,211.19708251953, _config = { stations = radio_stations }}
    },
    {
      {"entry",-603.997,58.954,98.200},
      {"chest",-621.323669433594,54.2074241638184,97.5995330810547, _config = {weight=500}},
      {"wardrobe",-594.668823242188,55.5750961303711,96.9996185302734},
      {"gametable",-606.140441894531,43.8849754333496,97.4350128173828},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -608.968322753906,49.1769981384277,97.4001312255859},
      {"radio", -601.69189453125,44.624042510986,97.400062561035, _config = { stations = radio_stations }}
    },
    {
      {"entry",-1453.013,-539.629,74.044},
      {"chest",-1466.57763671875,-528.339294433594,73.4436492919922, _config = {weight=500}},
      {"wardrobe",-1449.85034179688,-549.231323242188,72.8437194824219},
      {"gametable",-1466.37182617188,-546.663757324219,73.279052734375},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -1463.84411621094,-541.1962890625,73.2442169189453},
      {"radio", -1463.17578125,-549.80786132813,73.244178771973, _config = { stations = radio_stations }}
    },
    {
      {"entry",-912.547,-364.706,114.274},
      {"chest",-926.693176269531,-377.596130371094,113.674102783203, _config = {weight=500}},
      {"wardrobe",-903.66650390625,-364.023223876953,113.074157714844},
      {"gametable",-908.407165527344,-379.825714111328,113.509590148926},
      {"transformer", _config = {cfg = transformer_study, map_entity = {"PoI", {marker_id = 1}}}, -912.547,-364.706,114.274},
      {"radio", -904.83923339844,-377.26748657227,113.47455596924, _config = { stations = radio_stations }}
    }
  }
}

-- define home clusters
-- map of name => {.slot, .entry_point, .buy_price, .sell_price, .max, .map_entity}
--- map_entity: {ent,cfg} will fill cfg.title, cfg.pos
cfg.homes = {
  ["HLM Vinewood"] = {
    slot = "basic_flat",
    entry_point = {-635.665,44.155,42.697},
    buy_price = 100000,
    sell_price = 80000,
    max = 250,
    map_entity = {"PoI", {blip_id = 40, blip_color = 4, marker_id = 1}}
  },
  ["HLM Little Vinewood"] = {
    slot = "basic_flat",
    entry_point = {-599.255981445313,147.80744934082,61.672721862793},
    buy_price = 100000,
    sell_price = 80000,
    max = 250,
    map_entity = {"PoI", {blip_id = 40, blip_color = 4, marker_id = 1}}
  },
  ["HLM Little Seoul"] = {
    slot = "basic_flat",
    entry_point = {-767.436462402344,-751.6806640625,27.8752155303955},
    buy_price = 100000,
    sell_price = 80000,
    max = 250,
    map_entity = {"PoI", {blip_id = 40, blip_color = 4, marker_id = 1}}
  },
  ["Alesandro Hotel"] = {
    slot = "basic_flat",
    entry_point = {-599.255981445313,147.80744934082,61.672721862793},
    buy_price = 100000,
    sell_price = 80000,
    max = 50,
    map_entity = {"PoI", {blip_id = 40, blip_color = 4, marker_id = 1}}
  },
  ["Le Burton"] = {
    slot = "rich_flat",
    entry_point = {-417.206024169922,-187.134948730469,37.4518280029297},
    buy_price = 500000,
    sell_price = 350000,
    max = 30,
    map_entity = {"PoI", {blip_id = 40, blip_color = 5, marker_id = 1}}
  }
}

-- {ent,cfg} will fill cfg.pos
cfg.entry_map_entity = {"PoI", {marker_id = 1}}

return cfg
