Config                            = {}
Config.DrawDistance               = 100.0
Config.nameJob                    = "poolcleaner"
Config.nameJobLabel               = "Pool Cleaner"
Config.platePrefix                = "POOL"
Config.Locale                     = 'en'

Config.Blip = {
	Sprite = 389,
	Color = 3
}

Config.Vehicles = {
	Truck = {
		Spawner = 1,
		Label = 'Cleaner Utility',
		Hash = "bison5",
		Livery = 1,
		Trailer = "none",
	}
}

Config.Zones = {

	Cloakroom = {
		Pos     = {x = -1320.2412109375, y = -1263.4998779297, z = 4.587522983551},
		Size    = {x = 1.5, y = 1.5, z = 0.6},
		Color   = {r = 11, g = 203, b = 159},
		Type    = 21, Rotate = true,
		BlipSprite = 267,
		BlipColor = 3,
		BlipName = Config.nameJobLabel.." : Cloakroom",
		hint = 'Press ~INPUT_CONTEXT~ to access the cloakroom',
	},

	VehicleSpawner = {
		Pos   = {x = -1320.0230712891, y = -1251.2257080078, z = 4.5960249900818},
		Size  = {x = 1.5, y = 1.5, z = 0.6},
		Color = {r = 11, g = 203, b = 159},
		Type  = 36, Rotate = true,
		BlipSprite = 85,
		BlipColor = 3,
		BlipName = Config.nameJobLabel.." : Vehicles",
		hint = 'Press ~INPUT_CONTEXT~ to access the garage',
	},

	VehicleSpawnPoint = {
		Pos   = {x = -1320.75, y = -1254.54, z = 3.6},
		Size  = {x = 3.0, y = 3.0, z = 1.0},
		Type  = -1,
		Heading = 258.27,
	},

	VehicleDeleter = {
		Pos   = {x = -1310.6691894531, y = -1242.0057373047, z = 3.7231316566467},
		Size  = {x = 3.0, y = 3.0, z = 1},
		Color = {r = 255, g = 0, b = 0},
		Type  = 27, Rotate = false,
		BlipSprite = 380,
		BlipColor = 1,
		BlipName = Config.nameJobLabel.." : Return Vehicle",
		hint = 'Press ~INPUT_CONTEXT~ to return your vehicle',
	},

	Sale = {
		Pos   = {x = -1311.6273193359, y = -1262.6885986328, z =  3.5575785636902},
		Size  = {x = 3.5, y = 3.5, z = 0.6},
		Color = {r = 11, g = 203, b = 159},
		Type  = 27, Rotate = true,
		BlipSprite = 375,
		BlipColor = 3,
		BlipName = Config.nameJobLabel.." : Depot",

		ItemTime = 500,
		ItemDb_name = "poolreceipt",
		ItemName = "Pool Receipt",
		ItemMax = 15,
		ItemAdd = 1,
		ItemRemove = 1,
		ItemRequires = "poolreceipt",
		ItemRequires_name = "Pool Reciept",
		ItemDrop = 15,
		ItemPrice  = 100,
		hint = 'Press ~INPUT_CONTEXT~ to cash in your reciepts',
	},

}
Config.Pool = {
	{ ['x'] = -1340.8647460938, ['y'] = -923.14428710938, ['z'] = 11.597979545593}, 
	{ ['x'] = -2013.0478515625, ['y'] = -292.498046875, ['z'] = 31.937776565552}, 
	{ ['x'] = -2012.3701171875, ['y'] = -277.8821105957, ['z'] = 31.938255310059}, 
	{ ['x'] = -2022.1505126953, ['y'] = -304.8239440918, ['z'] = 31.967697143555}, 
	{ ['x'] = -1855.1086425781, ['y'] = -358.13757324219, ['z'] = 57.127880096436}, 
	{ ['x'] = -1862.4382324219, ['y'] = -345.77478027344, ['z'] = 55.809623718262}, 
	{ ['x'] = -1870.2897949219, ['y'] = -343.5432434082, ['z'] = 57.07633972168}, 
	{ ['x'] = -3047.9970703125, ['y'] = 39.833702087402, ['z'] = 10.117975234985}, 
	{ ['x'] = -3044.19921875, ['y'] = 59.873207092285, ['z'] = 10.118649482727}, 
	{ ['x'] = -3012.0563964844, ['y'] = 37.634052276611, ['z'] = 10.117904663086}, 
	{ ['x'] = -3033.3078613281, ['y'] = 31.719625473022, ['z'] = 10.118116378784}, 
	{ ['x'] = -2938.5646972656, ['y'] = 648.36004638672, ['z'] = 24.019474029541}, 
	{ ['x'] = -2943.748046875, ['y'] = 663.10626220703, ['z'] = 24.017618179321}, 
	{ ['x'] = -2963.7556152344, ['y'] = 696.70874023438, ['z'] = 28.339237213135}, 
	{ ['x'] = -2962.203125, ['y'] = 727.19079589844, ['z'] = 29.365261077881}, 
	{ ['x'] = -2969.1752929688, ['y'] = 729.73596191406, ['z'] = 29.285175323486}, 
	{ ['x'] = -2995.94921875, ['y'] = 756.28778076172, ['z'] = 26.606719970703}, 
	{ ['x'] = -2993.6098632812, ['y'] = 742.32971191406, ['z'] = 26.566679000854}, 
	{ ['x'] = -2633.8239746094, ['y'] = 1875.8510742188, ['z'] = 160.13452148438}, 
	{ ['x'] = -2639.0876464844, ['y'] = 1883.5345458984, ['z'] = 160.06700134277}, 
	{ ['x'] = -1599.8831787109, ['y'] = 762.55676269531, ['z'] = 189.41711425781}, 
	{ ['x'] = -1612.7629394531, ['y'] = 762.67816162109, ['z'] = 189.24319458008}, 
	{ ['x'] = -1607.5385742188, ['y'] = 774.87652587891, ['z'] = 189.24308776855}, 
	{ ['x'] = -1870.1827392578, ['y'] = 673.94299316406, ['z'] = 129.99938964844}, 
	{ ['x'] = -1876.7890625, ['y'] = 658.17755126953, ['z'] = 130.00015258789}, 
	{ ['x'] = -1862.5177001953, ['y'] = 662.43811035156, ['z'] = 130.00015258789}, 
	{ ['x'] = -1908.6088867188, ['y'] = 587.38354492188, ['z'] = 122.59703826904}, 
	{ ['x'] = -1909.8083496094, ['y'] = 597.17370605469, ['z'] = 122.75057220459}, 
	{ ['x'] = -1900.6253662109, ['y'] = 601.33288574219, ['z'] = 122.75057220459}, 
	{ ['x'] = -1996.7507324219, ['y'] = 639.90020751953, ['z'] = 122.53621673584}, 
	{ ['x'] = -1997.4368896484, ['y'] = 653.365234375, ['z'] = 122.5404510498}, 
	{ ['x'] = -2009.1573486328, ['y'] = 647.91143798828, ['z'] = 122.53622436523}, 
	{ ['x'] = -2015.4047851562, ['y'] = 603.52288818359, ['z'] = 117.09172821045}, 
	{ ['x'] = -2017.0607910156, ['y'] = 612.09228515625, ['z'] = 117.08603668213}, 
	{ ['x'] = -2023.0495605469, ['y'] = 600.86041259766, ['z'] = 117.09056091308}, 
	{ ['x'] = -2043.80078125, ['y'] = 499.28823852539, ['z'] = 106.47801208496}, 
	{ ['x'] = -2045.2803955078, ['y'] = 512.31671142578, ['z'] = 106.29371643066}, 
	{ ['x'] = -2036.6544189453, ['y'] = 520.36370849609, ['z'] = 106.29399871826}, 
	{ ['x'] = -1924.3304443359, ['y'] = 459.88888549805, ['z'] = 101.88073730469}, 
	{ ['x'] = -1926.2951660156, ['y'] = 446.69595336914, ['z'] = 101.85778045654}, 
	{ ['x'] = -1919.4514160156, ['y'] = 434.53121948242, ['z'] = 102.05239868164}, 
	{ ['x'] = -1914.7254638672, ['y'] = 445.24935913086, ['z'] = 103.34220123291}, 
	{ ['x'] = -2003.7229003906, ['y'] = 424.09439086914, ['z'] = 101.80992889404}, 
	{ ['x'] = -2020.0177001953, ['y'] = 424.91561889648, ['z'] = 101.8807144165}, 
	{ ['x'] = -2019.7672119141, ['y'] = 413.13879394531, ['z'] = 102.40422058105}, 
	{ ['x'] = -1916.841796875, ['y'] = 385.03335571289, ['z'] = 95.941108703613}, 
	{ ['x'] = -1899.8992919922, ['y'] = 387.11376953125, ['z'] = 96.014358520508}, 
	{ ['x'] = -1908.1486816406, ['y'] = 394.9775390625, ['z'] = 95.940162658691}, 
	{ ['x'] = -1919.7915039062, ['y'] = 391.66683959961, ['z'] = 95.838401794434}, 
	{ ['x'] = -2033.0078125, ['y'] = 370.6633605957, ['z'] = 93.955963134766}, 
	{ ['x'] = -2028.9146728516, ['y'] = 358.00170898438, ['z'] = 93.956359863281}, 
	{ ['x'] = -2031.6706542969, ['y'] = 350.13616943359, ['z'] = 93.957511901855}, 
	{ ['x'] = -2037.0178222656, ['y'] = 361.41482543945, ['z'] = 93.950622558594}, 
	{ ['x'] = -1901.5493164062, ['y'] = 358.39562988281, ['z'] = 92.651878356934}, 
	{ ['x'] = -1898.4431152344, ['y'] = 374.4189453125, ['z'] = 92.882942199707}, 
	{ ['x'] = -1891.8229980469, ['y'] = 366.79498291016, ['z'] = 93.050903320312}, 
	{ ['x'] = -1890.3228759766, ['y'] = 357.07272338867, ['z'] = 93.052551269531}, 
	{ ['x'] = -1887.0947265625, ['y'] = 289.24954223633, ['z'] = 88.854621887207}, 
	{ ['x'] = -1875.0712890625, ['y'] = 292.32113647461, ['z'] = 88.85725402832}, 
	{ ['x'] = -1874.6070556641, ['y'] = 284.08294677734, ['z'] = 88.854568481445}, 
	{ ['x'] = -1994.7066650391, ['y'] = 326.92001342773, ['z'] = 91.161605834961}, 
	{ ['x'] = -1993.3406982422, ['y'] = 319.20867919922, ['z'] = 91.351692199707}, 
	{ ['x'] = -2003.8908691406, ['y'] = 320.42504882812, ['z'] = 91.365539550781}, 
	{ ['x'] = -1984.3624267578, ['y'] = 238.61351013184, ['z'] = 86.668571472168}, 
	{ ['x'] = -1988.1223144531, ['y'] = 231.43853759766, ['z'] = 86.686729431152}, 
	{ ['x'] = -1994.4940185547, ['y'] = 240.91128540039, ['z'] = 86.683364868164}, 
	{ ['x'] = -1883.591796875, ['y'] = 256.54217529297, ['z'] = 85.534484863281}, 
	{ ['x'] = -1875.6478271484, ['y'] = 251.63243103027, ['z'] = 85.436553955078}, 
	{ ['x'] = -1877.982421875, ['y'] = 264.6457824707, ['z'] = 85.438362121582}, 
	{ ['x'] = -1991.5362548828, ['y'] = 202.20208740234, ['z'] = 86.598136901855}, 
	{ ['x'] = -1991.4127197266, ['y'] = 206.21325683594, ['z'] = 86.597145080566}, 
	{ ['x'] = -1955.1861572266, ['y'] = 152.14781188965, ['z'] = 84.139060974121}, 
	{ ['x'] = -1949.8355712891, ['y'] = 145.50317382812, ['z'] = 84.168533325195}, 
	{ ['x'] = -1958.0513916016, ['y'] = 136.01377868652, ['z'] = 84.166870117188}, 
	{ ['x'] = -1901.607421875, ['y'] = 357.67944335938, ['z'] = 92.646575927734}, 
	{ ['x'] = -1897.7381591797, ['y'] = 374.86544799805, ['z'] = 92.877319335938}, 
	{ ['x'] = -1892.4736328125, ['y'] = 369.34133911133, ['z'] = 92.904792785645}, 
	{ ['x'] = -1890.5180664062, ['y'] = 359.64367675781, ['z'] = 93.047470092773}, 
	{ ['x'] = -1894.8287353516, ['y'] = 352.23794555664, ['z'] = 92.797218322754}, 
	{ ['x'] = -1865.5444335938, ['y'] = 218.96517944336, ['z'] = 83.852584838867}, 
	{ ['x'] = -1858.7469482422, ['y'] = 224.93998718262, ['z'] = 83.857208251953}, 
	{ ['x'] = -1859.4132080078, ['y'] = 232.47637939453, ['z'] = 83.871116638184}, 
	{ ['x'] = -1923.0240478516, ['y'] = 130.46116638184, ['z'] = 81.517692565918}, 
	{ ['x'] = -1920.3651123047, ['y'] = 124.34127044678, ['z'] = 81.516334533691}, 
	{ ['x'] = -1911.1032714844, ['y'] = 124.07119750976, ['z'] = 81.995361328125}, 
	{ ['x'] = -2272.3833007812, ['y'] = 324.32025146484, ['z'] = 174.07571411133}, 
	{ ['x'] = -2250.0456542969, ['y'] = 257.33242797852, ['z'] = 174.08203125}, 
	{ ['x'] = -2246.4985351562, ['y'] = 242.16114807129, ['z'] = 174.01240539551}, 
	{ ['x'] = -1469.1798095703, ['y'] = 165.88822937012, ['z'] = 55.905456542969}, 
	{ ['x'] = -1476.2153320312, ['y'] = 177.26110839844, ['z'] = 55.918895721436}, 
	{ ['x'] = -1479.8154296875, ['y'] = 190.82548522949, ['z'] = 56.672306060791}, 
	{ ['x'] = -1461.4083251953, ['y'] = 181.64671325684, ['z'] = 55.921142578125}, 
	{ ['x'] = -1465.8421630859, ['y'] = 181.98136901855, ['z'] = 55.919883728027}, 
	{ ['x'] = -1460.5462646484, ['y'] = 176.81845092773, ['z'] = 55.921035766602}, 
	{ ['x'] = -1455.3686523438, ['y'] = 174.78102111816, ['z'] = 55.920433044434}, 
	{ ['x'] = -1627.8970947266, ['y'] = -18.07664680481, ['z'] = 61.021640777588}, 
	{ ['x'] = -1580.1411132812, ['y'] = 5.187707901001, ['z'] = 60.369571685791}, 
	{ ['x'] = -1592.3939208984, ['y'] = 3.4149289131165, ['z'] = 60.36888885498}, 
	{ ['x'] = -1584.4805908203, ['y'] = -0.94832497835159, ['z'] = 60.553291320801}, 
	{ ['x'] = -1531.2259521484, ['y'] = -0.090425342321396, ['z'] = 56.959331512451}, 
	{ ['x'] = -1537.5931396484, ['y'] = 1.2147591114044, ['z'] = 56.296047210693}, 
	{ ['x'] = -1532.3618164062, ['y'] = -7.2991271018982, ['z'] = 55.890357971191}, 
	{ ['x'] = -1524.6807861328, ['y'] = -6.2913537025452, ['z'] = 56.421073913574}, 
	{ ['x'] = -1475.3015136719, ['y'] = 11.357256889343, ['z'] = 54.027523040771}, 
	{ ['x'] = -1482.0017089844, ['y'] = 14.481190681458, ['z'] = 54.027477264404}, 
	{ ['x'] = -1498.5720214844, ['y'] = -34.55602645874, ['z'] = 54.107841491699}, 
	{ ['x'] = -1485.7071533203, ['y'] = -53.627410888672, ['z'] = 54.094039916992}, 
	{ ['x'] = -1481.5686035156, ['y'] = -64.585311889648, ['z'] = 54.095161437988}, 
	{ ['x'] = -1490.3874511719, ['y'] = -61.439342498779, ['z'] = 54.08723449707}, 
	{ ['x'] = -1495.6287841797, ['y'] = -51.207180023193, ['z'] = 54.090579986572}, 
	{ ['x'] = -1546.1303710938, ['y'] = -110.33308410644, ['z'] = 53.282146453857}, 
	{ ['x'] = -1538.4360351562, ['y'] = -106.41484832764, ['z'] = 53.233234405518}, 
	{ ['x'] = -1529.3140869141, ['y'] = -107.44849395752, ['z'] = 53.339553833008}, 
	{ ['x'] = -1530.4284667969, ['y'] = -113.13182067871, ['z'] = 53.237281799316}, 
	{ ['x'] = -1536.39453125, ['y'] = -114.18328094482, ['z'] = 53.229827880859}, 
	{ ['x'] = -1608.4436035156, ['y'] = -15.151955604553, ['z'] = 57.453369140625}, 
	{ ['x'] = -1610.4913330078, ['y'] = -22.539127349854, ['z'] = 57.454612731934}, 
	{ ['x'] = -1619.1561279297, ['y'] = -29.580936431885, ['z'] = 57.457363128662}, 
	{ ['x'] = -1368.8189697266, ['y'] = 333.35238647461, ['z'] = 63.733112335205}, 
	{ ['x'] = -1366.9171142578, ['y'] = 342.36535644531, ['z'] = 63.878540039062}, 
	{ ['x'] = -1338.7631835938, ['y'] = 362.56378173828, ['z'] = 63.55241394043}, 
	{ ['x'] = -1321.3326416016, ['y'] = 361.52160644531, ['z'] = 63.494079589844}, 
	{ ['x'] = -1316.3723144531, ['y'] = 347.33599853516, ['z'] = 63.537590026855}, 
	{ ['x'] = -1329.7918701172, ['y'] = 341.54061889648, ['z'] = 63.548053741455}, 
	{ ['x'] = -1346.1856689453, ['y'] = 341.85784912109, ['z'] = 63.55827331543}, 
	{ ['x'] = -1101.7757568359, ['y'] = 319.1774597168, ['z'] = 66.05265045166}, 
	{ ['x'] = -1106.0959472656, ['y'] = 325.16690063476, ['z'] = 66.052574157715}, 
	{ ['x'] = -1115.8699951172, ['y'] = 319.89096069336, ['z'] = 66.445251464844}, 
	{ ['x'] = -1027.0173339844, ['y'] = 293.88458251953, ['z'] = 66.15941619873}, 
	{ ['x'] = -1036.5467529297, ['y'] = 297.14950561523, ['z'] = 66.205299377441}, 
	{ ['x'] = -1035.6220703125, ['y'] = 291.20916748047, ['z'] = 66.050262451172}, 
	{ ['x'] = -1155.6170654297, ['y'] = 380.84573364258, ['z'] = 70.787811279297}, 
	{ ['x'] = -1158.6689453125, ['y'] = 371.45394897461, ['z'] = 68.870956420898}, 
	{ ['x'] = -1155.9869384766, ['y'] = 365.52185058594, ['z'] = 68.870338439941}, 
	{ ['x'] = -1162.310546875, ['y'] = 361.29595947266, ['z'] = 70.800048828125}, 
	{ ['x'] = -1165.2160644531, ['y'] = 369.23287963867, ['z'] = 70.781890869141}, 
	{ ['x'] = -1153.0916748047, ['y'] = 370.9831237793, ['z'] = 70.422607421875}, 
	{ ['x'] = -1151.0747070312, ['y'] = 363.27905273438, ['z'] = 70.79231262207}, 
	{ ['x'] = -1060.9771728516, ['y'] = 365.0817565918, ['z'] = 70.232223510742}, 
	{ ['x'] = -1059.9124755859, ['y'] = 359.42102050781, ['z'] = 70.261405944824}, 
	{ ['x'] = -1052.3447265625, ['y'] = 352.52825927734, ['z'] = 69.380332946777}, 
	{ ['x'] = -1049.4783935547, ['y'] = 363.35299682617, ['z'] = 69.388610839844}, 
	{ ['x'] = -878.69952392578, ['y'] = 337.44342041016, ['z'] = 84.623184204102}, 
	{ ['x'] = -873.16833496094, ['y'] = 346.54721069336, ['z'] = 84.579734802246}, 
	{ ['x'] = -878.15393066406, ['y'] = 345.40930175781, ['z'] = 84.740409851074}, 
	{ ['x'] = -887.396484375, ['y'] = 321.95565795898, ['z'] = 83.506500244141}, 
	{ ['x'] = -889.53887939453, ['y'] = 326.78793334961, ['z'] = 83.887176513672}, 
	{ ['x'] = -886.59039306641, ['y'] = 330.76156616211, ['z'] = 83.897682189941}, 
	{ ['x'] = -822.90606689453, ['y'] = 243.83961486816, ['z'] = 78.286109924316}, 
	{ ['x'] = -820.84143066406, ['y'] = 247.3978729248, ['z'] = 79.113021850586}, 
	{ ['x'] = -822.18505859375, ['y'] = 253.42584228516, ['z'] = 79.11328125}, 
	{ ['x'] = -823.89227294922, ['y'] = 253.39450073242, ['z'] = 78.804267883301}, 
	{ ['x'] = -830.86120605469, ['y'] = 254.65596008301, ['z'] = 78.684989929199}, 
	{ ['x'] = -834.509765625, ['y'] = 254.79267883301, ['z'] = 79.110954284668}, 
	{ ['x'] = -837.13366699219, ['y'] = 249.69067382812, ['z'] = 79.113006591797}, 
	{ ['x'] = -822.35168457031, ['y'] = 249.01489257812, ['z'] = 77.310096740723}, 
	{ ['x'] = -487.751953125, ['y'] = 183.82502746582, ['z'] = 83.158660888672}, 
	{ ['x'] = -478.54156494141, ['y'] = 187.21592712402, ['z'] = 83.157371520996}, 
	{ ['x'] = -474.26583862305, ['y'] = 182.72583007812, ['z'] = 83.197242736816}, 
	{ ['x'] = -479.37991333008, ['y'] = 182.0022277832, ['z'] = 82.004280090332}, 
	{ ['x'] = -485.69543457031, ['y'] = 180.19000244141, ['z'] = 83.198974609375}, 
	{ ['x'] = -289.96328735352, ['y'] = 159.10784912109, ['z'] = 87.39582824707}, 
	{ ['x'] = -299.24038696289, ['y'] = 154.83279418945, ['z'] = 87.393348693848}, 
	{ ['x'] = -310.03680419922, ['y'] = 161.12004089355, ['z'] = 87.387046813965}, 
	{ ['x'] = -299.74548339844, ['y'] = 161.88525390625, ['z'] = 86.613311767578}, 
	{ ['x'] = -293.17379760742, ['y'] = 160.71878051758, ['z'] = 86.964660644531}, 
	{ ['x'] = -789.19458007812, ['y'] = 405.8134765625, ['z'] = 91.61270904541}, 
	{ ['x'] = -793.99829101562, ['y'] = 416.07516479492, ['z'] = 91.612983703613}, 
	{ ['x'] = -796.56256103516, ['y'] = 412.00231933594, ['z'] = 91.612937927246}, 
	{ ['x'] = -702.78546142578, ['y'] = 422.10095214844, ['z'] = 106.36779022217}, 
	{ ['x'] = -711.28149414062, ['y'] = 428.15664672852, ['z'] = 106.37561035156}, 
	{ ['x'] = -710.34655761719, ['y'] = 439.54690551758, ['z'] = 106.37275695801}, 
	{ ['x'] = -702.18878173828, ['y'] = 435.67318725586, ['z'] = 106.39579772949}, 
	{ ['x'] = -652.36853027344, ['y'] = 459.45855712891, ['z'] = 109.91775512695}, 
	{ ['x'] = -661.21984863281, ['y'] = 454.91595458984, ['z'] = 109.85734558105}, 
	{ ['x'] = -656.69464111328, ['y'] = 437.84942626953, ['z'] = 109.96775054932}, 
	{ ['x'] = -649.32781982422, ['y'] = 440.89306640625, ['z'] = 109.86280059814}, 
	{ ['x'] = -608.05615234375, ['y'] = 451.33050537109, ['z'] = 109.02881622314}, 
	{ ['x'] = -619.41009521484, ['y'] = 462.3957824707, ['z'] = 108.293800354}, 
	{ ['x'] = -632.60845947266, ['y'] = 461.65222167969, ['z'] = 108.30457305908}, 
	{ ['x'] = -630.50567626953, ['y'] = 449.02847290039, ['z'] = 108.29377746582}, 
	{ ['x'] = -622.35491943359, ['y'] = 448.7746887207, ['z'] = 108.30005645752}, 
	{ ['x'] = -574.16320800781, ['y'] = 456.09191894531, ['z'] = 108.58438110352}, 
	{ ['x'] = -586.64752197266, ['y'] = 451.60549926758, ['z'] = 108.51090240479}, 
	{ ['x'] = -591.02575683594, ['y'] = 457.71157836914, ['z'] = 108.48606109619}, 
	{ ['x'] = -584.01751708984, ['y'] = 459.11083984375, ['z'] = 108.48802947998}, 
	{ ['x'] = -617.62426757812, ['y'] = 553.93432617188, ['z'] = 112.14353942871}, 
	{ ['x'] = -622.70001220703, ['y'] = 542.46221923828, ['z'] = 112.3014831543}, 
	{ ['x'] = -627.42376708984, ['y'] = 551.23010253906, ['z'] = 112.30207824707}, 
	{ ['x'] = -658.42523193359, ['y'] = 543.00146484375, ['z'] = 110.55561065674}, 
	{ ['x'] = -655.18109130859, ['y'] = 549.03698730469, ['z'] = 110.70899200439}, 
	{ ['x'] = -663.20751953125, ['y'] = 549.94366455078, ['z'] = 109.48410797119}, 
	{ ['x'] = -671.74322509766, ['y'] = 529.80035400391, ['z'] = 110.77674102783}, 
	{ ['x'] = -669.19549560547, ['y'] = 518.08465576172, ['z'] = 110.31581115723}, 
	{ ['x'] = -751.90728759766, ['y'] = 480.8889465332, ['z'] = 106.94633483887}, 
	{ ['x'] = -749.78741455078, ['y'] = 490.75308227539, ['z'] = 106.94743347168}, 
	{ ['x'] = -758.69860839844, ['y'] = 500.83782958984, ['z'] = 106.94116210938}, 
	{ ['x'] = -764.28558349609, ['y'] = 493.1139831543, ['z'] = 106.94094085693}, 
	{ ['x'] = -758.24639892578, ['y'] = 484.06240844726, ['z'] = 106.96857452393}, 
	{ ['x'] = -789.64520263672, ['y'] = 483.91055297852, ['z'] = 99.636093139648}, 
	{ ['x'] = -788.10064697266, ['y'] = 488.33792114258, ['z'] = 99.484909057617}, 
	{ ['x'] = -791.82836914062, ['y'] = 490.00396728516, ['z'] = 98.636199951172}, 
	{ ['x'] = -1026.3845214844, ['y'] = 424.47817993164, ['z'] = 72.333473205566}, 
	{ ['x'] = -1027.7437744141, ['y'] = 432.32214355469, ['z'] = 72.337745666504}, 
	{ ['x'] = -1023.9081420898, ['y'] = 420.96514892578, ['z'] = 72.334136962891}, 
	{ ['x'] = -1004.7617797852, ['y'] = 465.28176879883, ['z'] = 78.193145751953}, 
	{ ['x'] = -1004.6422729492, ['y'] = 456.60272216797, ['z'] = 78.192810058594}, 
	{ ['x'] = -998.55230712891, ['y'] = 465.95495605469, ['z'] = 78.245338439941}, 
	{ ['x'] = -1035.1839599609, ['y'] = 518.92535400391, ['z'] = 88.529365539551}, 
	{ ['x'] = -1040.0786132812, ['y'] = 516.6220703125, ['z'] = 88.753433227539}, 
	{ ['x'] = -936.62188720703, ['y'] = 497.91900634766, ['z'] = 81.143165588379}, 
	{ ['x'] = -934.75415039062, ['y'] = 503.37191772461, ['z'] = 81.140098571777}, 
	{ ['x'] = -940.13421630859, ['y'] = 509.45941162109, ['z'] = 81.139099121094}, 
	{ ['x'] = -944.10571289062, ['y'] = 505.1643371582, ['z'] = 81.139350891113}, 
	{ ['x'] = -979.28674316406, ['y'] = 460.6549987793, ['z'] = 81.366081237793}, 
	{ ['x'] = -990.8740234375, ['y'] = 464.97671508789, ['z'] = 81.366180419922}, 
	{ ['x'] = -983.15179443359, ['y'] = 468.82653808594, ['z'] = 81.411834716797}, 
	{ ['x'] = -998.16223144531, ['y'] = 445.45004272461, ['z'] = 79.971542358398}, 
	{ ['x'] = -998.01348876953, ['y'] = 436.45571899414, ['z'] = 80.017150878906}, 
	{ ['x'] = -990.46142578125, ['y'] = 434.86602783203, ['z'] = 79.971527099609}, 
	{ ['x'] = -930.65240478516, ['y'] = 481.44931030273, ['z'] = 84.273551940918}, 
	{ ['x'] = -929.86968994141, ['y'] = 489.86810302734, ['z'] = 84.273399353027}, 
	{ ['x'] = -925.08428955078, ['y'] = 488.34762573242, ['z'] = 84.271392822266}, 
	{ ['x'] = -922.98040771484, ['y'] = 480.82061767578, ['z'] = 84.27857208252}, 
	{ ['x'] = -820.37164306641, ['y'] = 456.26745605469, ['z'] = 89.638381958008}, 
	{ ['x'] = -813.64990234375, ['y'] = 461.95767211914, ['z'] = 89.645210266113}, 
	{ ['x'] = -894.16027832031, ['y'] = 478.42620849609, ['z'] = 87.871299743652}, 
	{ ['x'] = -898.89416503906, ['y'] = 472.47732543945, ['z'] = 87.885482788086}, 
	{ ['x'] = -835.14630126953, ['y'] = 497.60827636719, ['z'] = 89.983947753906}, 
	{ ['x'] = -826.47058105469, ['y'] = 495.64999389648, ['z'] = 89.990646362305}, 
	{ ['x'] = -835.98974609375, ['y'] = 490.01257324219, ['z'] = 89.988418579102}, 
	{ ['x'] = -840.58935546875, ['y'] = 493.63439941406, ['z'] = 89.988166809082}, 
	{ ['x'] = -903.92541503906, ['y'] = 510.39785766602, ['z'] = 91.798805236816}, 
	{ ['x'] = -905.60662841797, ['y'] = 502.9755859375, ['z'] = 91.801750183105}, 
	{ ['x'] = -911.11767578125, ['y'] = 505.7707824707, ['z'] = 91.799247741699}, 
	{ ['x'] = -908.38671875, ['y'] = 512.96453857422, ['z'] = 91.79744720459}, 
	{ ['x'] = -849.80157470703, ['y'] = 548.0693359375, ['z'] = 94.64916229248}, 
	{ ['x'] = -848.7041015625, ['y'] = 538.17840576172, ['z'] = 93.063095092773}, 
	{ ['x'] = -889.63909912109, ['y'] = 577.61932373047, ['z'] = 100.41204833984}, 
	{ ['x'] = -884.93933105469, ['y'] = 583.87182617188, ['z'] = 100.43734741211}, 
	{ ['x'] = -883.61645507812, ['y'] = 575.68884277344, ['z'] = 100.46179962158}, 
	{ ['x'] = -941.68322753906, ['y'] = 607.26220703125, ['z'] = 109.68537139893}, 
	{ ['x'] = -932.29144287109, ['y'] = 607.77374267578, ['z'] = 109.80010986328}, 
	{ ['x'] = -933.23583984375, ['y'] = 614.32800292969, ['z'] = 109.76359558105}, 
	{ ['x'] = -941.26348876953, ['y'] = 617.44830322266, ['z'] = 109.76469421387}, 
	{ ['x'] = -945.67468261719, ['y'] = 614.7041015625, ['z'] = 109.76533508301}, 
	{ ['x'] = -1066.4327392578, ['y'] = 564.3203125, ['z'] = 102.90818023682}, 
	{ ['x'] = -1071.306640625, ['y'] = 572.91705322266, ['z'] = 102.90833282471}, 
	{ ['x'] = -1064.0681152344, ['y'] = 579.27868652344, ['z'] = 102.90850067139}, 
	{ ['x'] = -1058.3284912109, ['y'] = 574.11779785156, ['z'] = 102.9083480835}, 
	{ ['x'] = -1058.4868164062, ['y'] = 563.15997314453, ['z'] = 102.90825653076}, 
	{ ['x'] = -1135.8775634766, ['y'] = 610.68688964844, ['z'] = 104.37149810791}, 
	{ ['x'] = -1131.4099121094, ['y'] = 602.88562011719, ['z'] = 104.36096954346}, 
	{ ['x'] = -1122.2504882812, ['y'] = 603.49822998047, ['z'] = 104.39626312256}, 
	{ ['x'] = -1123.595703125, ['y'] = 610.97784423828, ['z'] = 104.39549255371}, 
	{ ['x'] = -1132.7939453125, ['y'] = 615.72088623047, ['z'] = 104.39593505859}, 
	{ ['x'] = -1170.7716064453, ['y'] = 608.46203613281, ['z'] = 102.16506195068}, 
	{ ['x'] = -1171.5552978516, ['y'] = 599.97277832031, ['z'] = 102.31646728516}, 
	{ ['x'] = -1264.0609130859, ['y'] = 495.861328125, ['z'] = 96.817993164062}, 
	{ ['x'] = -1305.9166259766, ['y'] = 495.09603881836, ['z'] = 97.70295715332}, 
	{ ['x'] = -1307.1668701172, ['y'] = 481.71096801758, ['z'] = 97.754722595215}, 
	{ ['x'] = -1301.3861083984, ['y'] = 477.85968017578, ['z'] = 97.684051513672}, 
	{ ['x'] = -1295.7098388672, ['y'] = 484.87442016602, ['z'] = 97.657699584961}, 
	{ ['x'] = -1069.8000488281, ['y'] = 500.28833007812, ['z'] = 85.123497009277}, 
	{ ['x'] = -1068.5723876953, ['y'] = 506.35308837891, ['z'] = 85.108093261719}, 
	{ ['x'] = -1062.4558105469, ['y'] = 499.15115356445, ['z'] = 85.106170654297}, 
	{ ['x'] = -1069.7390136719, ['y'] = 497.20098876953, ['z'] = 85.108047485352}, 
	{ ['x'] = -1116.9396972656, ['y'] = 434.95956420898, ['z'] = 74.771354675293}, 
	{ ['x'] = -1110.6412353516, ['y'] = 431.11938476562, ['z'] = 74.758209228516}, 
	{ ['x'] = -1118.4825439453, ['y'] = 427.96197509766, ['z'] = 74.755851745605}, 
	{ ['x'] = -1119.3386230469, ['y'] = 431.2536315918, ['z'] = 74.829483032226}, 
	{ ['x'] = -1027.6179199219, ['y'] = 428.32748413086, ['z'] = 72.337890625}, 
	{ ['x'] = -1115.6654052734, ['y'] = 514.72100830078, ['z'] = 81.674186706543}, 
	{ ['x'] = -1109.7664794922, ['y'] = 513.40020751953, ['z'] = 81.67798614502}, 
	{ ['x'] = -1106.4405517578, ['y'] = 509.75064086914, ['z'] = 81.676368713379}, 
	{ ['x'] = -1114.5556640625, ['y'] = 507.11926269531, ['z'] = 81.658981323242}, 
	{ ['x'] = -1121.8424072266, ['y'] = 511.70587158203, ['z'] = 81.658172607422}, 
	{ ['x'] = -1155.7593994141, ['y'] = 504.51400756836, ['z'] = 86.09391784668}, 
	{ ['x'] = -1149.9625244141, ['y'] = 508.42004394531, ['z'] = 86.188186645508}, 
	{ ['x'] = -1158.9783935547, ['y'] = 511.74523925781, ['z'] = 86.101783752441}, 
	{ ['x'] = -1153.5925292969, ['y'] = 434.78668212891, ['z'] = 85.886749267578}, 
	{ ['x'] = -1146.4217529297, ['y'] = 442.54266357422, ['z'] = 86.097496032715}, 
	{ ['x'] = -1222.5128173828, ['y'] = 437.78665161133, ['z'] = 85.616622924805}, 
	{ ['x'] = -1215.4533691406, ['y'] = 437.85989379883, ['z'] = 85.616622924805}, 
	{ ['x'] = -1213.4390869141, ['y'] = 438.54455566406, ['z'] = 85.616546630859}, 
	{ ['x'] = -1206.5426025391, ['y'] = 432.87036132812, ['z'] = 85.613441467285}, 
	{ ['x'] = -1267.7727050781, ['y'] = 438.04605102539, ['z'] = 94.937744140625}, 
	{ ['x'] = -1265.3013916016, ['y'] = 433.72244262695, ['z'] = 94.852119445801}, 
	{ ['x'] = -1266.9909667969, ['y'] = 436.03323364258, ['z'] = 95.21883392334}, 
	{ ['x'] = -1322.4749755859, ['y'] = 425.82763671875, ['z'] = 99.683036804199}, 
	{ ['x'] = -1321.6850585938, ['y'] = 423.23434448242, ['z'] = 99.827102661133}, 
	{ ['x'] = -1333.2003173828, ['y'] = 439.83401489258, ['z'] = 100.61389160156}, 
	{ ['x'] = -1340.2083740234, ['y'] = 433.66784667969, ['z'] = 100.66971588135}, 
	{ ['x'] = -1341.1683349609, ['y'] = 426.69375610352, ['z'] = 100.61408233643}, 
	{ ['x'] = -1324.1921386719, ['y'] = 511.98355102539, ['z'] = 104.11869812012}, 
	{ ['x'] = -1324.1136474609, ['y'] = 517.31408691406, ['z'] = 104.61840057373}, 
	{ ['x'] = -1855.6000976562, ['y'] = 289.8434753418, ['z'] = 89.132461547852}, 
	{ ['x'] = -1843.4493408203, ['y'] = 292.49371337891, ['z'] = 89.137001037598}, 
	{ ['x'] = -1778.5935058594, ['y'] = 323.71484375, ['z'] = 88.440719604492}, 
	{ ['x'] = -1786.0852050781, ['y'] = 319.89791870117, ['z'] = 88.445198059082}, 
	{ ['x'] = -1772.5048828125, ['y'] = 328.10250854492, ['z'] = 88.446266174316}, 
	{ ['x'] = -1767.2227783203, ['y'] = 335.99517822266, ['z'] = 88.848335266113}, 
	{ ['x'] = -1726.6877441406, ['y'] = 339.93872070312, ['z'] = 86.803535461426}, 
	{ ['x'] = -1708.6745605469, ['y'] = 356.19183349609, ['z'] = 86.769348144531}, 
	{ ['x'] = -1717.4377441406, ['y'] = 368.69720458984, ['z'] = 89.22225189209}, 
	{ ['x'] = -1713.6954345703, ['y'] = 373.19296264648, ['z'] = 89.29859161377}, 
	{ ['x'] = -1683.7312011719, ['y'] = 366.87677001953, ['z'] = 84.114860534668}, 
	{ ['x'] = -1673.1606445312, ['y'] = 362.27337646484, ['z'] = 84.233322143555}, 
	{ ['x'] = -1680.6463623047, ['y'] = 359.87014770508, ['z'] = 84.155090332031}, 
	{ ['x'] = -1689.9016113281, ['y'] = 368.04946899414, ['z'] = 84.059875488281}, 
	{ ['x'] = -1770.0043945312, ['y'] = 434.21472167969, ['z'] = 126.74351501465}, 
	{ ['x'] = -1776.0489501953, ['y'] = 440.80313110352, ['z'] = 126.80911254883}, 
	{ ['x'] = -1527.3204345703, ['y'] = 392.82965087891, ['z'] = 107.48313903808}, 
	{ ['x'] = -1515.9052734375, ['y'] = 396.91763305664, ['z'] = 107.47814178467}, 
	{ ['x'] = -1527.1960449219, ['y'] = 385.68707275391, ['z'] = 106.47595214844}, 
	{ ['x'] = -1472.5949707031, ['y'] = 420.41098022461, ['z'] = 112.39479827881}, 
	{ ['x'] = -1480.0295410156, ['y'] = 428.99401855469, ['z'] = 112.43840026855}, 
	{ ['x'] = -1476.7797851562, ['y'] = 435.40188598633, ['z'] = 112.43664550781}, 
	{ ['x'] = -1467.744140625, ['y'] = 430.65798950195, ['z'] = 112.43849945068}, 
	{ ['x'] = -1463.9217529297, ['y'] = 423.86267089844, ['z'] = 112.40168762207}, 
	{ ['x'] = -1456.9176025391, ['y'] = 483.2624206543, ['z'] = 115.67188262939}, 
	{ ['x'] = -1467.9671630859, ['y'] = 479.94931030273, ['z'] = 115.66884613037}, 
	{ ['x'] = -1459.3048095703, ['y'] = 476.16842651367, ['z'] = 115.67335510254}, 
	{ ['x'] = -1452.6010742188, ['y'] = 479.42428588867, ['z'] = 115.66918945312}, 
	{ ['x'] = -1382.0736083984, ['y'] = 504.00268554688, ['z'] = 120.50618743896}, 
	{ ['x'] = -1391.0108642578, ['y'] = 496.85739135742, ['z'] = 120.50519561768}, 
	{ ['x'] = -1394.63671875, ['y'] = 508.72137451172, ['z'] = 120.50031280518}, 
	{ ['x'] = -1389.3596191406, ['y'] = 506.99606323242, ['z'] = 119.36538696289}, 
	{ ['x'] = -1402.4412841797, ['y'] = 583.94934082031, ['z'] = 125.85614776611}, 
	{ ['x'] = -1413.6998291016, ['y'] = 581.85736083984, ['z'] = 125.86637115479}, 
	{ ['x'] = -1321.7473144531, ['y'] = 544.89654541016, ['z'] = 123.81328582764}, 
	{ ['x'] = -1329.0977783203, ['y'] = 545.03961181641, ['z'] = 123.77513885498}, 
	{ ['x'] = -1334.9886474609, ['y'] = 537.50006103516, ['z'] = 123.75166320801}, 
	{ ['x'] = -1337.4654541016, ['y'] = 531.59020996094, ['z'] = 123.74808502197}, 
	{ ['x'] = -1382.0167236328, ['y'] = 589.14123535156, ['z'] = 131.92428588867}, 
	{ ['x'] = -1382.6282958984, ['y'] = 584.49676513672, ['z'] = 131.68406677246}, 
	{ ['x'] = -1385.1458740234, ['y'] = 585.38330078125, ['z'] = 131.68496704102}, 
	{ ['x'] = -1300.4144287109, ['y'] = 572.87066650391, ['z'] = 129.60397338867}, 
	{ ['x'] = -1291.2198486328, ['y'] = 576.53265380859, ['z'] = 129.59733581543}, 
	{ ['x'] = -1290.4184570312, ['y'] = 585.07690429688, ['z'] = 129.59257507324}, 
	{ ['x'] = -1298.140625, ['y'] = 582.42803955078, ['z'] = 129.59326171875}, 
	{ ['x'] = -1396.5968017578, ['y'] = 609.25317382812, ['z'] = 131.55616760254}, 
	{ ['x'] = -1396.5777587891, ['y'] = 603.77478027344, ['z'] = 131.5611114502}, 
	{ ['x'] = -1395.4045410156, ['y'] = 599.51605224609, ['z'] = 131.5611114502}, 
	{ ['x'] = -1391.2850341797, ['y'] = 607.50628662109, ['z'] = 131.56106567383}, 
	{ ['x'] = -1276.1077880859, ['y'] = 600.09417724609, ['z'] = 138.7240447998}, 
	{ ['x'] = -1265.3770751953, ['y'] = 601.18505859375, ['z'] = 138.75205993652}, 
	{ ['x'] = -1261.7233886719, ['y'] = 599.07818603516, ['z'] = 138.71524047852}, 
	{ ['x'] = -1241.16796875, ['y'] = 617.53186035156, ['z'] = 137.9623260498}, 
	{ ['x'] = -1233.4180908203, ['y'] = 623.76129150391, ['z'] = 138.04849243164}, 
	{ ['x'] = -1226.8878173828, ['y'] = 618.58825683594, ['z'] = 138.02183532715}, 
	{ ['x'] = -1234.4809570312, ['y'] = 611.30242919922, ['z'] = 137.91114807129}, 
	{ ['x'] = -1135.9779052734, ['y'] = 719.25646972656, ['z'] = 154.93933105469}, 
	{ ['x'] = -1144.37890625, ['y'] = 709.65838623047, ['z'] = 154.93907165527}, 
	{ ['x'] = -1144.1401367188, ['y'] = 702.58001708984, ['z'] = 154.93145751953}, 
	{ ['x'] = -1137.0838623047, ['y'] = 705.66705322266, ['z'] = 154.94175720215}, 
	{ ['x'] = -1130.6301269531, ['y'] = 714.9951171875, ['z'] = 154.94122314453}, 
	{ ['x'] = -1117.4945068359, ['y'] = 726.91638183594, ['z'] = 158.66604614258}, 
	{ ['x'] = -1105.4935302734, ['y'] = 727.37756347656, ['z'] = 158.66580200195}, 
	{ ['x'] = -1101.6170654297, ['y'] = 735.06500244141, ['z'] = 158.26319885254}, 
	{ ['x'] = -1146.8725585938, ['y'] = 815.54241943359, ['z'] = 166.86112976074}, 
	{ ['x'] = -1150.7966308594, ['y'] = 808.41027832031, ['z'] = 166.86116027832}, 
	{ ['x'] = -1149.4774169922, ['y'] = 800.08215332031, ['z'] = 166.83631896973}, 
	{ ['x'] = -1089.1262207031, ['y'] = 830.05572509766, ['z'] = 168.43676757812}, 
	{ ['x'] = -1098.5992431641, ['y'] = 833.15808105469, ['z'] = 168.61030578613}, 
	{ ['x'] = -1103.0290527344, ['y'] = 837.23919677734, ['z'] = 168.43865966797}, 
	{ ['x'] = -1068.5167236328, ['y'] = 827.36340332031, ['z'] = 165.93643188476}, 
	{ ['x'] = -1059.0375976562, ['y'] = 838.03820800781, ['z'] = 166.20419311523}, 
	{ ['x'] = -1067.0249023438, ['y'] = 845.44085693359, ['z'] = 166.30877685547}, 
	{ ['x'] = -1070.5988769531, ['y'] = 841.1103515625, ['z'] = 166.29888916016}, 
	{ ['x'] = -1023.9856567383, ['y'] = 833.78448486328, ['z'] = 171.91242980957}, 
	{ ['x'] = -1012.024597168, ['y'] = 841.91479492188, ['z'] = 171.91128540039}, 
	{ ['x'] = -1019.5321655273, ['y'] = 847.35382080078, ['z'] = 171.91409301758}, 
	{ ['x'] = -971.35894775391, ['y'] = 724.49304199219, ['z'] = 172.69683837891}, 
	{ ['x'] = -965.77221679688, ['y'] = 726.47406005859, ['z'] = 172.87715148926}, 
	{ ['x'] = -968.91729736328, ['y'] = 736.13775634766, ['z'] = 172.8772277832}, 
	{ ['x'] = -976.07659912109, ['y'] = 741.62408447266, ['z'] = 172.83596801758}, 
	{ ['x'] = -1022.760925293, ['y'] = 772.12750244141, ['z'] = 170.66999816894}, 
	{ ['x'] = -1020.6074829102, ['y'] = 766.10882568359, ['z'] = 170.68270874023}, 
	{ ['x'] = -1025.2209472656, ['y'] = 761.40045166016, ['z'] = 170.68286132812}, 
	{ ['x'] = -1029.2983398438, ['y'] = 769.62731933594, ['z'] = 170.68232727051}, 
	{ ['x'] = -1015.5557861328, ['y'] = 840.09735107422, ['z'] = 171.83525085449}, 
	{ ['x'] = -1021.3505859375, ['y'] = 833.52648925781, ['z'] = 172.44055175781}, 
	{ ['x'] = -964.21527099609, ['y'] = 844.52935791016, ['z'] = 177.03639221191}, 
	{ ['x'] = -971.390625, ['y'] = 850.15362548828, ['z'] = 177.08564758301}, 
	{ ['x'] = -982.47003173828, ['y'] = 843.10943603516, ['z'] = 177.1408996582}, 
	{ ['x'] = -977.328125, ['y'] = 836.59765625, ['z'] = 177.09857177734}, 
	{ ['x'] = -915.93939208984, ['y'] = 838.97222900391, ['z'] = 185.4107208252}, 
	{ ['x'] = -910.32159423828, ['y'] = 837.63049316406, ['z'] = 185.41040039062}, 
	{ ['x'] = -920.62048339844, ['y'] = 743.9296875, ['z'] = 181.25061035156}, 
	{ ['x'] = -905.748046875, ['y'] = 744.05413818359, ['z'] = 181.28294372558}, 
	{ ['x'] = -868.91131591797, ['y'] = 763.78594970703, ['z'] = 191.19343566894}, 
	{ ['x'] = -859.99987792969, ['y'] = 759.97833251953, ['z'] = 191.30790710449}, 
	{ ['x'] = -861.18072509766, ['y'] = 753.73706054688, ['z'] = 191.30462646484}, 
	{ ['x'] = -870.544921875, ['y'] = 760.94384765625, ['z'] = 191.1944732666}, 
	{ ['x'] = -872.10833740234, ['y'] = 751.97698974609, ['z'] = 191.19749450684}, 
	{ ['x'] = -811.24151611328, ['y'] = 788.34533691406, ['z'] = 201.66403198242}, 
	{ ['x'] = -815.13195800781, ['y'] = 791.32263183594, ['z'] = 201.68156433105}, 
	{ ['x'] = -765.04302978516, ['y'] = 773.958984375, ['z'] = 212.6727142334}, 
	{ ['x'] = -758.64434814453, ['y'] = 773.12487792969, ['z'] = 212.65356445312}, 
	{ ['x'] = -748.38500976562, ['y'] = 777.52752685547, ['z'] = 212.73553466797}, 
	{ ['x'] = -739.61712646484, ['y'] = 782.52386474609, ['z'] = 212.71389770508}, 
	{ ['x'] = -746.72692871094, ['y'] = 785.45300292969, ['z'] = 212.75611877441}, 
	{ ['x'] = -756.16644287109, ['y'] = 781.89117431641, ['z'] = 212.75660705566}, 
	{ ['x'] = -666.86303710938, ['y'] = 881.85955810547, ['z'] = 224.62159729004}, 
	{ ['x'] = -667.58233642578, ['y'] = 872.91009521484, ['z'] = 224.52906799316}, 
	{ ['x'] = -669.44909667969, ['y'] = 864.29534912109, ['z'] = 224.52481079102}, 
	{ ['x'] = -671.13519287109, ['y'] = 856.20336914062, ['z'] = 224.57189941406}, 
	{ ['x'] = -674.91442871094, ['y'] = 851.56506347656, ['z'] = 224.52290344238}, 
	{ ['x'] = -677.59423828125, ['y'] = 854.68426513672, ['z'] = 224.6328125}, 
	{ ['x'] = -675.40106201172, ['y'] = 858.42767333984, ['z'] = 224.62086486816}, 
	{ ['x'] = -677.31457519531, ['y'] = 864.43023681641, ['z'] = 224.71516418457}, 
	{ ['x'] = -676.78021240234, ['y'] = 871.82312011719, ['z'] = 224.71508789062}, 
	{ ['x'] = -676.24688720703, ['y'] = 880.39074707031, ['z'] = 224.7135925293}, 
	{ ['x'] = -628.24340820312, ['y'] = 841.26977539062, ['z'] = 205.31739807129}, 
	{ ['x'] = -628.65869140625, ['y'] = 836.78063964844, ['z'] = 206.25149536133}, 
	{ ['x'] = -625.58056640625, ['y'] = 832.05358886719, ['z'] = 206.25564575195}, 
	{ ['x'] = -618.88507080078, ['y'] = 825.46838378906, ['z'] = 206.25564575195}, 
	{ ['x'] = -615.71343994141, ['y'] = 828.80670166016, ['z'] = 206.25564575195}, 
	{ ['x'] = -617.76568603516, ['y'] = 837.26251220703, ['z'] = 206.1397857666}, 
	{ ['x'] = -539.77368164062, ['y'] = 790.86468505859, ['z'] = 196.99816894531}, 
	{ ['x'] = -541.23107910156, ['y'] = 782.21911621094, ['z'] = 197.02662658691}, 
	{ ['x'] = -547.63781738281, ['y'] = 784.09948730469, ['z'] = 197.0217590332}, 
	{ ['x'] = -551.75238037109, ['y'] = 792.29693603516, ['z'] = 197.02226257324}, 
	{ ['x'] = -549.98876953125, ['y'] = 795.71484375, ['z'] = 197.02401733398}, 
	{ ['x'] = -497.47393798828, ['y'] = 776.30120849609, ['z'] = 178.27920532226}, 
	{ ['x'] = -501.63287353516, ['y'] = 777.41351318359, ['z'] = 178.34034729004}, 
	{ ['x'] = -543.29736328125, ['y'] = 612.41680908203, ['z'] = 137.23393249512}, 
	{ ['x'] = -542.88684082031, ['y'] = 621.01422119141, ['z'] = 136.93353271484}, 
	{ ['x'] = -551.84509277344, ['y'] = 622.67462158203, ['z'] = 137.32878112793}, 
	{ ['x'] = -554.29010009766, ['y'] = 619.34155273438, ['z'] = 137.3286895752}, 
	{ ['x'] = -567.79974365234, ['y'] = 583.65484619141, ['z'] = 114.43682098389}, 
	{ ['x'] = -566.58020019531, ['y'] = 578.06976318359, ['z'] = 114.43927764893}, 
	{ ['x'] = -575.27606201172, ['y'] = 573.15545654297, ['z'] = 114.76480865479}, 
	{ ['x'] = -582.44549560547, ['y'] = 571.56536865234, ['z'] = 114.49461364746}, 
	{ ['x'] = -588.392578125, ['y'] = 574.23510742188, ['z'] = 114.4451675415}, 
	{ ['x'] = -566.83917236328, ['y'] = 554.84942626953, ['z'] = 109.86083221436}, 
	{ ['x'] = -572.43334960938, ['y'] = 546.38061523438, ['z'] = 109.8928604126}, 
	{ ['x'] = -566.22705078125, ['y'] = 545.02166748047, ['z'] = 109.90970611572}, 
	{ ['x'] = -500.587890625, ['y'] = 494.16110229492, ['z'] = 107.24830627441}, 
	{ ['x'] = -496.8092956543, ['y'] = 489.50717163086, ['z'] = 107.24391937256}, 
	{ ['x'] = -611.25756835938, ['y'] = 628.42242431641, ['z'] = 150.51152038574}, 
	{ ['x'] = -624.09429931641, ['y'] = 622.79406738281, ['z'] = 150.51608276367}, 
	{ ['x'] = -607.53204345703, ['y'] = 619.56372070312, ['z'] = 150.50907897949}, 
	{ ['x'] = -638.16564941406, ['y'] = 673.33020019531, ['z'] = 150.14793395996}, 
	{ ['x'] = -640.51983642578, ['y'] = 659.02410888672, ['z'] = 150.10484313965}, 
	{ ['x'] = -647.09320068359, ['y'] = 615.18884277344, ['z'] = 147.6325378418}, 
	{ ['x'] = -656.67706298828, ['y'] = 609.85424804688, ['z'] = 147.63037109375}, 
	{ ['x'] = -664.99835205078, ['y'] = 619.20135498047, ['z'] = 147.6279296875}, 
	{ ['x'] = -790.81121826172, ['y'] = 649.232421875, ['z'] = 139.26438903808}, 
	{ ['x'] = -783.89697265625, ['y'] = 635.52166748047, ['z'] = 139.26438903808}, 
	{ ['x'] = -790.72906494141, ['y'] = 633.52020263672, ['z'] = 139.26440429688}, 
	{ ['x'] = -790.94165039062, ['y'] = 640.66174316406, ['z'] = 139.35189819336}, 
	{ ['x'] = -838.78747558594, ['y'] = 685.03802490234, ['z'] = 146.35198974609}, 
	{ ['x'] = -833.51715087891, ['y'] = 694.00708007812, ['z'] = 146.3392791748}, 
	{ ['x'] = -1069.9024658203, ['y'] = 708.10614013672, ['z'] = 165.46455383301}, 
	{ ['x'] = -1054.6853027344, ['y'] = 701.73583984375, ['z'] = 165.46549987793}, 
	{ ['x'] = -833.17266845703, ['y'] = 692.32708740234, ['z'] = 146.33224487305}, 
	{ ['x'] = -453.56823730469, ['y'] = 624.53479003906, ['z'] = 142.41856384277}, 
	{ ['x'] = -446.13153076172, ['y'] = 620.45037841797, ['z'] = 142.40798950195}, 
	{ ['x'] = -443.42922973633, ['y'] = 626.77545166016, ['z'] = 142.41499328613}, 
	{ ['x'] = -433.79327392578, ['y'] = 693.06610107422, ['z'] = 152.54167175293}, 
	{ ['x'] = -440.00894165039, ['y'] = 703.59167480469, ['z'] = 152.53984069824}, 
	{ ['x'] = -434.98361206055, ['y'] = 708.75335693359, ['z'] = 152.5378112793}, 
	{ ['x'] = -533.41253662109, ['y'] = 456.67645263672, ['z'] = 102.66446685791}, 
	{ ['x'] = -524.14587402344, ['y'] = 462.29006958008, ['z'] = 102.67394256592}, 
	{ ['x'] = -491.56677246094, ['y'] = 440.86920166016, ['z'] = 96.170372009277}, 
	{ ['x'] = -490.27703857422, ['y'] = 450.50671386719, ['z'] = 96.174774169922}, 
	{ ['x'] = -482.08053588867, ['y'] = 445.3659362793, ['z'] = 96.169944763184}, 
	{ ['x'] = -469.3805847168, ['y'] = 428.4963684082, ['z'] = 102.58911132812}, 
	{ ['x'] = -473.65518188476, ['y'] = 435.71676635742, ['z'] = 102.59499359131}, 
	{ ['x'] = -325.40951538086, ['y'] = 342.30062866211, ['z'] = 109.51263427734}, 
	{ ['x'] = -322.72323608398, ['y'] = 347.90719604492, ['z'] = 109.537940979}, 
	{ ['x'] = -317.49914550781, ['y'] = 349.38830566406, ['z'] = 109.49443054199}, 
	{ ['x'] = -236.93377685547, ['y'] = 352.57287597656, ['z'] = 110.23837280273}, 
	{ ['x'] = -241.19534301758, ['y'] = 358.86737060547, ['z'] = 110.64614868164}, 
	{ ['x'] = -248.98022460938, ['y'] = 360.16030883789, ['z'] = 110.64655303955}, 
	{ ['x'] = -206.48352050781, ['y'] = 369.73452758789, ['z'] = 109.27853393555}, 
	{ ['x'] = -193.30038452148, ['y'] = 370.51516723633, ['z'] = 109.2830657959}, 
	{ ['x'] = -189.68254089355, ['y'] = 376.58560180664, ['z'] = 109.2794418335}, 
	{ ['x'] = -198.36726379394, ['y'] = 376.75793457031, ['z'] = 109.27848815918}, 
	{ ['x'] = -148.76390075684, ['y'] = 399.8669128418, ['z'] = 111.02684783936}, 
	{ ['x'] = -150.36291503906, ['y'] = 394.22964477539, ['z'] = 111.02774810791}, 
	{ ['x'] = -157.66088867188, ['y'] = 392.6103515625, ['z'] = 111.02856445312}, 
	{ ['x'] = -161.39477539062, ['y'] = 396.84246826172, ['z'] = 111.22660827637}, 
	{ ['x'] = -155.97671508789, ['y'] = 401.22729492188, ['z'] = 111.22762298584}, 
	{ ['x'] = -166.2060546875, ['y'] = 392.45291137695, ['z'] = 111.22718048096}, 
	{ ['x'] = -163.74443054199, ['y'] = 386.60470581055, ['z'] = 111.28198242188}, 
	{ ['x'] = -311.05380249023, ['y'] = 408.48907470703, ['z'] = 109.05470275879}, 
	{ ['x'] = -302.44979858398, ['y'] = 408.22592163086, ['z'] = 109.08919525146}, 
	{ ['x'] = -363.42608642578, ['y'] = 395.44653320312, ['z'] = 111.07421875}, 
	{ ['x'] = -355.73916625976, ['y'] = 391.72991943359, ['z'] = 111.19200897217}, 
	{ ['x'] = -357.73394775391, ['y'] = 384.60650634766, ['z'] = 111.19203948975}, 
	{ ['x'] = -429.55291748047, ['y'] = 426.619140625, ['z'] = 113.09648132324}, 
	{ ['x'] = -435.00982666016, ['y'] = 433.26251220703, ['z'] = 113.10132598877}, 
	{ ['x'] = -432.16168212891, ['y'] = 443.07629394531, ['z'] = 112.31513977051}, 
	{ ['x'] = -430.26519775391, ['y'] = 442.49325561523, ['z'] = 113.12646484375}, 
	{ ['x'] = -427.67269897461, ['y'] = 438.59396362305, ['z'] = 113.10159301758}, 
	{ ['x'] = -426.46398925781, ['y'] = 430.03491210938, ['z'] = 113.09780883789}, 
	{ ['x'] = -435.62063598633, ['y'] = 373.07537841797, ['z'] = 108.48394012451}, 
	{ ['x'] = -433.13919067383, ['y'] = 380.94305419922, ['z'] = 108.4870300293}, 
	{ ['x'] = -426.16873168945, ['y'] = 383.86721801758, ['z'] = 108.22537994385}, 
	{ ['x'] = -659.046875, ['y'] = 749.16156005859, ['z'] = 174.03869628906}, 
	{ ['x'] = -650.07843017578, ['y'] = 747.78741455078, ['z'] = 174.04316711426}, 
	{ ['x'] = -651.02459716797, ['y'] = 741.01177978516, ['z'] = 174.03942871094}, 
	{ ['x'] = -602.21795654297, ['y'] = 708.42175292969, ['z'] = 180.01623535156}, 
	{ ['x'] = -591.609375, ['y'] = 702.56799316406, ['z'] = 180.05766296387}, 
	{ ['x'] = -593.283203125, ['y'] = 707.85345458984, ['z'] = 180.021484375}, 
	{ ['x'] = -398.26541137695, ['y'] = 486.76245117188, ['z'] = 119.93029022217}, 
	{ ['x'] = -405.78570556641, ['y'] = 480.35205078125, ['z'] = 120.29860687256}, 
	{ ['x'] = -395.13577270508, ['y'] = 471.60049438476, ['z'] = 120.19854736328}, 
	{ ['x'] = -379.14987182617, ['y'] = 448.49407958984, ['z'] = 113.75091552734}, 
	{ ['x'] = -371.88290405273, ['y'] = 445.04876708984, ['z'] = 113.71192169189}, 
	{ ['x'] = -355.3994140625, ['y'] = 391.62030029297, ['z'] = 111.19116973877}, 
	{ ['x'] = -361.70693969726, ['y'] = 394.05960083008, ['z'] = 111.3903427124}, 
	{ ['x'] = -429.80981445312, ['y'] = 441.84231567383, ['z'] = 113.10139465332}, 
	{ ['x'] = -425.91485595703, ['y'] = 429.75839233398, ['z'] = 113.10144042969}, 
	{ ['x'] = -247.88656616211, ['y'] = 467.13052368164, ['z'] = 126.81906890869}, 
	{ ['x'] = -241.7364654541, ['y'] = 457.39672851562, ['z'] = 126.7400894165}, 
	{ ['x'] = -230.95794677734, ['y'] = 463.37124633789, ['z'] = 126.75383758545}, 
	{ ['x'] = -180.28622436523, ['y'] = 484.76287841797, ['z'] = 133.75912475586}, 
	{ ['x'] = -183.12617492676, ['y'] = 477.36764526367, ['z'] = 133.74517822266}, 
	{ ['x'] = -110.5757598877, ['y'] = 488.54766845703, ['z'] = 137.03044128418}, 
	{ ['x'] = -122.26639556885, ['y'] = 490.15100097656, ['z'] = 137.03134155273}, 
	{ ['x'] = -127.64534759521, ['y'] = 487.35232543945, ['z'] = 137.03132629394}, 
	{ ['x'] = -117.28018951416, ['y'] = 478.17953491211, ['z'] = 137.03146362305}, 
	{ ['x'] = -108.41018676758, ['y'] = 477.51751708984, ['z'] = 137.03146362305}, 
	{ ['x'] = -79.902214050293, ['y'] = 473.80267333984, ['z'] = 137.59378051758}, 
	{ ['x'] = -67.944709777832, ['y'] = 467.34692382812, ['z'] = 137.60516357422}, 
	{ ['x'] = -72.75267791748, ['y'] = 463.70391845703, ['z'] = 137.59457397461}, 
	{ ['x'] = -78.996948242188, ['y'] = 465.91879272461, ['z'] = 137.59394836426}, 
	{ ['x'] = 23.253435134888, ['y'] = 436.73538208008, ['z'] = 142.91624450684}, 
	{ ['x'] = 31.339670181274, ['y'] = 432.64739990234, ['z'] = 142.91525268555}, 
	{ ['x'] = 34.687595367432, ['y'] = 423.77151489258, ['z'] = 142.9153137207}, 
	{ ['x'] = 25.0934715271, ['y'] = 426.58203125, ['z'] = 142.91580200195}, 
	{ ['x'] = 161.93869018555, ['y'] = 481.40972900391, ['z'] = 142.26724243164}, 
	{ ['x'] = 153.7032623291, ['y'] = 481.86407470703, ['z'] = 142.30204772949}, 
	{ ['x'] = 158.93957519531, ['y'] = 473.72821044922, ['z'] = 142.26850891113}, 
	{ ['x'] = 233.03825378418, ['y'] = 636.03100585938, ['z'] = 185.83181762695}, 
	{ ['x'] = 241.09049987793, ['y'] = 643.72595214844, ['z'] = 185.8246307373}, 
	{ ['x'] = 248.77291870117, ['y'] = 643.07897949219, ['z'] = 185.82452392578}, 
	{ ['x'] = 245.18104553223, ['y'] = 636.08673095703, ['z'] = 185.82467651367}, 
	{ ['x'] = 240.31050109863, ['y'] = 630.76574707031, ['z'] = 185.82531738281}, 
	{ ['x'] = 184.06526184082, ['y'] = 556.00506591797, ['z'] = 179.94213867188}, 
	{ ['x'] = 176.89663696289, ['y'] = 548.67504882812, ['z'] = 179.94165039062}, 
	{ ['x'] = 175.59637451172, ['y'] = 544.10949707031, ['z'] = 179.94195556641}, 
	{ ['x'] = 170.81384277344, ['y'] = 543.31243896484, ['z'] = 179.96348571777}, 
	{ ['x'] = 48.677265167236, ['y'] = 536.22546386719, ['z'] = 175.32232666016}, 
	{ ['x'] = 58.433082580566, ['y'] = 533.51239013672, ['z'] = 175.36849975586}, 
	{ ['x'] = 50.789520263672, ['y'] = 528.22705078125, ['z'] = 175.32069396973}, 
	{ ['x'] = 21.547185897827, ['y'] = 530.52313232422, ['z'] = 170.63352966308}, 
	{ ['x'] = 23.169414520264, ['y'] = 523.71441650391, ['z'] = 170.22776794434}, 
	{ ['x'] = 14.404493331909, ['y'] = 521.78063964844, ['z'] = 170.22761535644}, 
	{ ['x'] = 5.3973278999329, ['y'] = 517.24334716797, ['z'] = 170.22761535644}, 
	{ ['x'] = -458.37457275391, ['y'] = 572.82446289062, ['z'] = 125.878074646}, 
	{ ['x'] = -461.9533996582, ['y'] = 566.27838134766, ['z'] = 125.8782119751}, 
	{ ['x'] = -327.44873046875, ['y'] = 605.36883544922, ['z'] = 172.35444641113}, 
	{ ['x'] = -322.22741699219, ['y'] = 602.4130859375, ['z'] = 172.35450744629}, 
	{ ['x'] = -373.25924682617, ['y'] = 682.60540771484, ['z'] = 169.6513671875}, 
	{ ['x'] = -372.5803527832, ['y'] = 688.70324707031, ['z'] = 168.15644836426}, 
	{ ['x'] = -367.03131103516, ['y'] = 694.35382080078, ['z'] = 168.15644836426}, 
	{ ['x'] = -361.82711791992, ['y'] = 692.54010009766, ['z'] = 168.15644836426}, 
	{ ['x'] = -362.54275512695, ['y'] = 688.05706787109, ['z'] = 169.65232849121}, 
	{ ['x'] = -357.80905151367, ['y'] = 690.17425537109, ['z'] = 169.65180969238}, 
	{ ['x'] = -313.76513671875, ['y'] = 649.20660400391, ['z'] = 174.73866271973}, 
	{ ['x'] = -310.93902587891, ['y'] = 652.89294433594, ['z'] = 176.1162109375}, 
	{ ['x'] = -284.73944091797, ['y'] = 572.02520751953, ['z'] = 173.28955078125}, 
	{ ['x'] = -274.33660888672, ['y'] = 566.76013183594, ['z'] = 173.21714782715}, 
	{ ['x'] = -283.52227783203, ['y'] = 563.90106201172, ['z'] = 173.29341125488}, 
	{ ['x'] = -245.69976806641, ['y'] = 571.13134765625, ['z'] = 184.77076721191}, 
	{ ['x'] = -235.60917663574, ['y'] = 570.10437011719, ['z'] = 184.79150390625}, 
	{ ['x'] = -227.92449951172, ['y'] = 564.30267333984, ['z'] = 184.95452880859}, 
	{ ['x'] = -237.14738464355, ['y'] = 653.33215332031, ['z'] = 187.77577209473}, 
	{ ['x'] = -251.11373901367, ['y'] = 656.05511474609, ['z'] = 187.77700805664}, 
	{ ['x'] = -251.40237426758, ['y'] = 665.17596435547, ['z'] = 187.86518859863}, 
	{ ['x'] = -234.26176452637, ['y'] = 661.40954589844, ['z'] = 187.87437438965}, 
	{ ['x'] = -200.66595458984, ['y'] = 665.6357421875, ['z'] = 200.14233398438}, 
	{ ['x'] = -199.13310241699, ['y'] = 663.52111816406, ['z'] = 200.67456054688}, 
	{ ['x'] = -197.15246582031, ['y'] = 655.38970947266, ['z'] = 200.67066955566}, 
	{ ['x'] = -199.94921875, ['y'] = 651.13513183594, ['z'] = 200.67695617676}, 
	{ ['x'] = -180.01702880859, ['y'] = 565.35290527344, ['z'] = 188.80352783203}, 
	{ ['x'] = -175.22308349609, ['y'] = 564.79119873047, ['z'] = 188.81292724609}, 
	{ ['x'] = -182.79209899902, ['y'] = 564.75280761719, ['z'] = 189.76942443848}, 
	{ ['x'] = -113.22708129883, ['y'] = 574.11694335938, ['z'] = 195.46566772461}, 
	{ ['x'] = -126.81963348389, ['y'] = 573.68963623047, ['z'] = 195.58209228516}, 
	{ ['x'] = -130.21527099609, ['y'] = 565.72534179688, ['z'] = 195.47117614746}, 
	{ ['x'] = -112.21614074707, ['y'] = 566.05804443359, ['z'] = 195.46463012695}, 
	{ ['x'] = -188.7225189209, ['y'] = 969.3642578125, ['z'] = 232.32804870605}, 
	{ ['x'] = -198.74644470215, ['y'] = 969.18878173828, ['z'] = 231.53428649902}, 
	{ ['x'] = -204.3325958252, ['y'] = 974.31066894531, ['z'] = 231.53382873535}, 
	{ ['x'] = -208.84564208984, ['y'] = 983.93572998047, ['z'] = 231.53382873535}, 
	{ ['x'] = -209.22229003906, ['y'] = 992.43585205078, ['z'] = 231.53381347656}, 
	{ ['x'] = -209.17723083496, ['y'] = 998.70404052734, ['z'] = 231.53381347656}, 
	{ ['x'] = -204.26301574707, ['y'] = 1000.4144287109, ['z'] = 231.53381347656}, 
	{ ['x'] = -197.13902282715, ['y'] = 995.21685791016, ['z'] = 231.53378295898}, 
	{ ['x'] = -196.0255279541, ['y'] = 985.80004882812, ['z'] = 231.53378295898}, 
	{ ['x'] = -187.8350982666, ['y'] = 968.39324951172, ['z'] = 231.60771179199}, 
	{ ['x'] = -71.493003845215, ['y'] = 952.95129394531, ['z'] = 232.28004455566}, 
	{ ['x'] = -83.69637298584, ['y'] = 948.98059082031, ['z'] = 232.27874755859}, 
	{ ['x'] = -96.817649841309, ['y'] = 955.00598144531, ['z'] = 232.28294372558}, 
	{ ['x'] = -94.820701599121, ['y'] = 964.58221435547, ['z'] = 232.28520202637}, 
	{ ['x'] = -84.254936218262, ['y'] = 972.18756103516, ['z'] = 232.62106323242}, 
	{ ['x'] = -79.629386901855, ['y'] = 965.80816650391, ['z'] = 232.28173828125}, 
	{ ['x'] = -149.63758850098, ['y'] = 868.32122802734, ['z'] = 232.48289489746}, 
	{ ['x'] = -162.79833984375, ['y'] = 869.51177978516, ['z'] = 232.48243713379}, 
	{ ['x'] = -171.71203613281, ['y'] = 877.21899414062, ['z'] = 232.61833190918}, 
	{ ['x'] = -57.533275604248, ['y'] = 807.30718994141, ['z'] = 226.97859191894}, 
	{ ['x'] = -63.920467376709, ['y'] = 804.08508300781, ['z'] = 226.95727539062}, 
	{ ['x'] = -49.529747009277, ['y'] = 805.76470947266, ['z'] = 226.97853088379}, 
	{ ['x'] = -45.224761962891, ['y'] = 794.23468017578, ['z'] = 226.97721862793}, 
	{ ['x'] = -47.205017089844, ['y'] = 784.92205810547, ['z'] = 227.23170471191}, 
	{ ['x'] = 221.32928466797, ['y'] = 487.62915039062, ['z'] = 140.14518737793}, 
	{ ['x'] = 219.47280883789, ['y'] = 477.20666503906, ['z'] = 140.17213439941}, 
	{ ['x'] = 226.45973205566, ['y'] = 481.39785766602, ['z'] = 140.17938232422}, 
	{ ['x'] = 300.94866943359, ['y'] = 530.53631591797, ['z'] = 152.59034729004}, 
	{ ['x'] = 292.78747558594, ['y'] = 534.51556396484, ['z'] = 152.61415100098}, 
	{ ['x'] = 289.45071411133, ['y'] = 527.89019775391, ['z'] = 152.60366821289}, 
	{ ['x'] = 282.43597412109, ['y'] = 513.25207519531, ['z'] = 150.49443054199}, 
	{ ['x'] = 280.71975708008, ['y'] = 506.07769775391, ['z'] = 148.09875488281}, 
	{ ['x'] = 283.60501098633, ['y'] = 493.4831237793, ['z'] = 148.09635925293}, 
	{ ['x'] = 291.25186157226, ['y'] = 491.75387573242, ['z'] = 148.17393493652}, 
	{ ['x'] = 291.19595336914, ['y'] = 499.49505615234, ['z'] = 148.17393493652}, 
	{ ['x'] = 306.84759521484, ['y'] = 460.87048339844, ['z'] = 142.85925292969}, 
	{ ['x'] = 302.1969909668, ['y'] = 454.65368652344, ['z'] = 142.85931396484}, 
	{ ['x'] = 294.04373168945, ['y'] = 460.71661376953, ['z'] = 142.86026000976}, 
	{ ['x'] = 512.48608398438, ['y'] = 220.40141296387, ['z'] = 104.21286010742}, 
	{ ['x'] = 514.68182373047, ['y'] = 209.47027587891, ['z'] = 104.74398040771}, 
	{ ['x'] = 504.65463256836, ['y'] = 208.15043640137, ['z'] = 104.82445526123}, 
	{ ['x'] = 493.85415649414, ['y'] = 215.57124328613, ['z'] = 104.74476623535}, 
	{ ['x'] = 300.29699707031, ['y'] = 467.59725952148, ['z'] = 142.85925292969}, 
	{ ['x'] = 304.93029785156, ['y'] = 454.7883605957, ['z'] = 142.86135864258}, 
	{ ['x'] = 295.98504638672, ['y'] = 457.06640625, ['z'] = 142.85919189453}, 
	{ ['x'] = -26.313396453857, ['y'] = 343.08856201172, ['z'] = 112.63096618652}, 
	{ ['x'] = -26.593399047852, ['y'] = 330.43420410156, ['z'] = 112.62959289551}, 
	{ ['x'] = -14.084480285645, ['y'] = 330.95269775391, ['z'] = 112.63330841064}, 
	{ ['x'] = -8.4134912490845, ['y'] = 343.89282226562, ['z'] = 112.6333770752}, 
	{ ['x'] = -9.1400785446167, ['y'] = 351.79635620117, ['z'] = 112.63446807861}, 
	{ ['x'] = -20.640230178833, ['y'] = 351.09323120117, ['z'] = 112.63488006592}, 
	{ ['x'] = -1008.448425293, ['y'] = 230.42660522461, ['z'] = 64.740966796875}, 
	{ ['x'] = -1006.4845581055, ['y'] = 222.41957092285, ['z'] = 64.787216186523}, 
	{ ['x'] = -1006.8246459961, ['y'] = 214.72618103027, ['z'] = 64.743957519531}, 
	{ ['x'] = -1011.8380126953, ['y'] = 218.30125427246, ['z'] = 64.745986938476}, 
	{ ['x'] = -1012.0624389648, ['y'] = 146.30017089844, ['z'] = 57.177867889404}, 
	{ ['x'] = -1017.0787963867, ['y'] = 151.68226623535, ['z'] = 57.183841705322}, 
	{ ['x'] = -1018.6335449219, ['y'] = 145.31394958496, ['z'] = 57.178142547607}, 
	{ ['x'] = -1013.8908081055, ['y'] = 141.20545959473, ['z'] = 57.181201934814}, 
	{ ['x'] = -997.44195556641, ['y'] = 113.8521194458, ['z'] = 55.137256622314}, 
	{ ['x'] = -1002.8721313476, ['y'] = 120.88790130615, ['z'] = 55.150424957275}, 
	{ ['x'] = -1001.0293579102, ['y'] = 125.88300323486, ['z'] = 55.121627807617}, 
	{ ['x'] = -994.45788574219, ['y'] = 126.72092437744, ['z'] = 55.122734069824}, 
	{ ['x'] = -989.93664550781, ['y'] = 120.01588439941, ['z'] = 55.118343353271}, 
	{ ['x'] = -893.98797607422, ['y'] = 99.238235473633, ['z'] = 54.183032989502}, 
	{ ['x'] = -888.00494384766, ['y'] = 98.932716369629, ['z'] = 54.184967041016}, 
	{ ['x'] = -884.63494873047, ['y'] = 101.42240905762, ['z'] = 54.17992401123}, 
	{ ['x'] = -889.33294677734, ['y'] = 107.33044433594, ['z'] = 54.385417938232}, 
	{ ['x'] = -901.87683105469, ['y'] = 172.38334655762, ['z'] = 68.915252685547}, 
	{ ['x'] = -885.81646728516, ['y'] = 172.2733001709, ['z'] = 68.91088104248}, 
	{ ['x'] = -874.14538574219, ['y'] = 187.04315185547, ['z'] = 69.710624694824}, 
	{ ['x'] = -879.72912597656, ['y'] = 188.08757019043, ['z'] = 69.306427001953}, 
	{ ['x'] = -951.40411376953, ['y'] = 220.11711120605, ['z'] = 66.822822570801}, 
	{ ['x'] = -951.04125976562, ['y'] = 212.27928161621, ['z'] = 67.221031188965}, 
	{ ['x'] = -956.95819091797, ['y'] = 211.56387329102, ['z'] = 67.219512939453}, 
	{ ['x'] = -960.71545410156, ['y'] = 215.96182250976, ['z'] = 66.822738647461}, 
	{ ['x'] = -959.45867919922, ['y'] = 221.14562988281, ['z'] = 66.819961547852}, 
	{ ['x'] = -947.06591796875, ['y'] = 46.013446807861, ['z'] = 49.291431427002}, 
	{ ['x'] = -947.66638183594, ['y'] = 54.823204040527, ['z'] = 49.549633026123}, 
	{ ['x'] = -951.10003662109, ['y'] = 61.862243652344, ['z'] = 50.063899993896}, 
	{ ['x'] = -956.47784423828, ['y'] = 55.152660369873, ['z'] = 50.011276245117}, 
	{ ['x'] = -951.95812988281, ['y'] = 46.27481842041, ['z'] = 49.284427642822}, 
	{ ['x'] = -907.13604736328, ['y'] = -25.252307891846, ['z'] = 41.482524871826}, 
	{ ['x'] = -897.48522949219, ['y'] = -27.283504486084, ['z'] = 41.449817657471}, 
	{ ['x'] = -890.7109375, ['y'] = -46.442169189453, ['z'] = 37.716857910156}, 
	{ ['x'] = -899.26153564453, ['y'] = -43.222286224365, ['z'] = 37.718280792236}, 
	{ ['x'] = -888.27709960938, ['y'] = -40.694442749023, ['z'] = 37.712623596191}, 
	{ ['x'] = -918.72955322266, ['y'] = 54.101959228516, ['z'] = 49.683238983154}, 
	{ ['x'] = -913.33337402344, ['y'] = 57.492446899414, ['z'] = 47.71577835083}, 
	{ ['x'] = -910.99975585938, ['y'] = 62.000537872314, ['z'] = 47.715881347656}, 
	{ ['x'] = -907.99035644531, ['y'] = 60.634071350098, ['z'] = 49.617977142334}, 
	{ ['x'] = -801.50714111328, ['y'] = 119.55609130859, ['z'] = 56.319622039795}, 
	{ ['x'] = -792.54479980469, ['y'] = 118.21099090576, ['z'] = 56.319561004639}, 
	{ ['x'] = -785.86218261719, ['y'] = 117.84876251221, ['z'] = 56.319507598877}, 
	{ ['x'] = -783.64489746094, ['y'] = 124.02005767822, ['z'] = 56.317600250244}, 
	{ ['x'] = -791.06060791016, ['y'] = 181.88008117676, ['z'] = 72.303840637207}, 
	{ ['x'] = -781.07354736328, ['y'] = 185.3868560791, ['z'] = 72.313682556152}, 
	{ ['x'] = -782.24237060547, ['y'] = 177.98937988281, ['z'] = 72.308776855469}, 
	{ ['x'] = -577.36267089844, ['y'] = 111.17667388916, ['z'] = 67.725257873535}, 
	{ ['x'] = -570.18493652344, ['y'] = 104.6569442749, ['z'] = 67.722869873047}, 
	{ ['x'] = -572.45330810547, ['y'] = 93.421661376953, ['z'] = 67.792083740234}, 
	{ ['x'] = -582.52532958984, ['y'] = 88.542427062988, ['z'] = 67.726547241211}, 
	{ ['x'] = -593.26525878906, ['y'] = 89.31958770752, ['z'] = 67.61213684082}, 
	{ ['x'] = -597.65057373047, ['y'] = 94.284034729004, ['z'] = 68.297668457031}, 
	{ ['x'] = -590.40734863281, ['y'] = 101.07375335693, ['z'] = 67.669372558594}, 
	{ ['x'] = -112.09809875488, ['y'] = 18.209728240967, ['z'] = 68.905151367188}, 
	{ ['x'] = -121.63492584229, ['y'] = 15.724464416504, ['z'] = 68.888031005859}, 
	{ ['x'] = -115.18296813965, ['y'] = 8.6243019104004, ['z'] = 68.887626647949}, 
	{ ['x'] = -107.74554443359, ['y'] = 11.17666053772, ['z'] = 68.884132385254}, 
	{ ['x'] = -6.9870285987854, ['y'] = -34.463500976562, ['z'] = 68.473159790039}, 
	{ ['x'] = -14.155360221863, ['y'] = -40.167255401611, ['z'] = 68.466987609863}, 
	{ ['x'] = -14.151997566223, ['y'] = -33.16300201416, ['z'] = 68.466697692871}, 
	{ ['x'] = 267.98907470703, ['y'] = 51.810848236084, ['z'] = 88.474258422852}, 
	{ ['x'] = 256.853515625, ['y'] = 44.678951263428, ['z'] = 88.474258422852}, 
	{ ['x'] = 248.99905395508, ['y'] = 49.041996002197, ['z'] = 88.474258422852}, 
	{ ['x'] = 251.4285736084, ['y'] = 53.614032745361, ['z'] = 88.345611572266}, 
	{ ['x'] = 75.29426574707, ['y'] = -244.91423034668, ['z'] = 48.194023132324}, 
	{ ['x'] = 71.685531616211, ['y'] = -238.72457885742, ['z'] = 48.188236236572}, 
	{ ['x'] = 80.644828796387, ['y'] = -238.56535339355, ['z'] = 48.18824005127}, 
	{ ['x'] = 87.918266296387, ['y'] = -246.16516113281, ['z'] = 48.188255310059}, 
	{ ['x'] = 93.053718566895, ['y'] = -248.81846618652, ['z'] = 47.416084289551}, 
	{ ['x'] = 98.302261352539, ['y'] = -244.7093963623, ['z'] = 47.416568756104}, 
	{ ['x'] = 103.22927093506, ['y'] = -250.99633789062, ['z'] = 47.416568756104}, 
	{ ['x'] = 157.23538208008, ['y'] = -272.22457885742, ['z'] = 46.315879821777}, 
	{ ['x'] = 166.20079040527, ['y'] = -273.31915283203, ['z'] = 46.308567047119}, 
	{ ['x'] = 158.56130981445, ['y'] = -266.83712768555, ['z'] = 46.308349609375}, 
	{ ['x'] = 328.41891479492, ['y'] = -195.67098999023, ['z'] = 54.226421356201}, 
	{ ['x'] = 336.77270507812, ['y'] = -193.85321044922, ['z'] = 54.226474761963}, 
	{ ['x'] = 343.45639038086, ['y'] = -200.75971984863, ['z'] = 54.22643661499}, 
	{ ['x'] = 334.01681518555, ['y'] = -199.81831359863, ['z'] = 54.226474761963}, 
	{ ['x'] = -1184.2635498047, ['y'] = -231.58613586426, ['z'] = 37.953300476074}, 
	{ ['x'] = -1196.9010009766, ['y'] = -234.07582092285, ['z'] = 37.95601272583}, 
	{ ['x'] = -1196.5922851562, ['y'] = -244.91250610352, ['z'] = 37.956890106201}, 
	{ ['x'] = -1183.7657470703, ['y'] = -242.3712310791, ['z'] = 37.958179473877}, 
	{ ['x'] = -1550.8245849609, ['y'] = -263.94869995117, ['z'] = 48.266399383545}, 
	{ ['x'] = -1546.9685058594, ['y'] = -270.80438232422, ['z'] = 46.702259063721}, 
	{ ['x'] = -1543.6583251953, ['y'] = -263.72317504883, ['z'] = 46.707225799561}, 
	{ ['x'] = -1541.7927246094, ['y'] = -260.78939819336, ['z'] = 48.266101837158}, 
	{ ['x'] = -1544.2570800781, ['y'] = -272.47515869141, ['z'] = 48.268604278564}, 
	{ ['x'] = -1540.0654296875, ['y'] = -266.81628417969, ['z'] = 48.267677307129}, 
	{ ['x'] = -1654.2744140625, ['y'] = -421.49014282226, ['z'] = 41.610572814941}, 
	{ ['x'] = -1649.8707275391, ['y'] = -425.98486328125, ['z'] = 41.621856689453}, 
	{ ['x'] = -1654.6131591797, ['y'] = -430.11935424805, ['z'] = 41.621994018555}, 
	{ ['x'] = -1658.2386474609, ['y'] = -426.40710449219, ['z'] = 41.621234893799}, 
	{ ['x'] = -1659.6983642578, ['y'] = -420.93389892578, ['z'] = 41.617462158203}, 
	{ ['x'] = -1656.2828369141, ['y'] = -427.61096191406, ['z'] = 41.622081756592}, 
	{ ['x'] = -1659.1317138672, ['y'] = -419.57501220703, ['z'] = 41.626342773438}, 
	{ ['x'] = -1700.5296630859, ['y'] = -463.00296020508, ['z'] = 41.587757110596}, 
	{ ['x'] = -1709.6610107422, ['y'] = -461.46688842773, ['z'] = 41.587791442871}, 
	{ ['x'] = -1708.0141601562, ['y'] = -468.27151489258, ['z'] = 41.587791442871}, 
	{ ['x'] = -1705.1151123047, ['y'] = -475.66720581055, ['z'] = 41.588764190674}, 
	{ ['x'] = -1698.7160644531, ['y'] = -468.89508056641, ['z'] = 41.587955474854}, 
	{ ['x'] = -1345.7103271484, ['y'] = -924.09283447266, ['z'] = 11.752907752991}, 
	{ ['x'] = -1346.9392089844, ['y'] = -932.64001464844, ['z'] = 11.752931594849}, 
	{ ['x'] = -1479.7282714844, ['y'] = -680.11968994141, ['z'] = 28.307397842407}, 
	{ ['x'] = -1488.4172363281, ['y'] = -680.37969970703, ['z'] = 28.307598114014}, 
	{ ['x'] = -1488.2572021484, ['y'] = -685.70782470703, ['z'] = 28.307500839233}, 
	{ ['x'] = -982.00451660156, ['y'] = -1500.5374755859, ['z'] = 5.5867028236389}, 
	{ ['x'] = -990.88647460938, ['y'] = -1508.3898925781, ['z'] = 5.5867509841919}, 
	{ ['x'] = -999.61822509766, ['y'] = -1504.0040283203, ['z'] = 5.586874961853}, 
	{ ['x'] = -1004.973449707, ['y'] = -1496.9755859375, ['z'] = 5.5880560874939}, 
	{ ['x'] = -995.63348388672, ['y'] = -1492.1843261719, ['z'] = 5.5869460105896}, 
	{ ['x'] = -988.83666992188, ['y'] = -1488.9139404297, ['z'] = 5.5867552757263}, 
	{ ['x'] = -988.53930664062, ['y'] = -1488.7637939453, ['z'] = 5.5867519378662}, 
	{ ['x'] = -737.65460205078, ['y'] = -1006.5022583008, ['z'] = 18.176538467407}, 
	{ ['x'] = -733.65753173828, ['y'] = -997.61267089844, ['z'] = 18.177541732788}, 
	{ ['x'] = -724.01525878906, ['y'] = -995.73126220703, ['z'] = 18.17734336853}, 
	{ ['x'] = -720.37536621094, ['y'] = -1001.8122558594, ['z'] = 18.177337646484}, 
	{ ['x'] = -725.75769042969, ['y'] = -1006.1121826172, ['z'] = 18.206411361694}, 
	{ ['x'] = -792.69757080078, ['y'] = -785.80279541016, ['z'] = 27.872318267822}, 
	{ ['x'] = -794.61480712891, ['y'] = -778.18914794922, ['z'] = 27.872638702393}, 
	{ ['x'] = -788.11492919922, ['y'] = -775.23364257812, ['z'] = 27.872247695923}, 
	{ ['x'] = -784.609375, ['y'] = -783.05529785156, ['z'] = 27.917589187622}, 
	{ ['x'] = -783.59259033203, ['y'] = -789.37451171875, ['z'] = 27.872421264648}, 
	{ ['x'] = -789.21875, ['y'] = -792.60565185547, ['z'] = 27.872446060181}, 
	{ ['x'] = -556.18511962891, ['y'] = -790.84265136719, ['z'] = 30.69825553894}, 
	{ ['x'] = -549.8916015625, ['y'] = -798.75231933594, ['z'] = 30.737424850464}, 
	{ ['x'] = -543.83618164062, ['y'] = -790.57214355469, ['z'] = 30.699674606323}, 
	{ ['x'] = -548.61944580078, ['y'] = -780.68273925781, ['z'] = 30.697490692139}, 
	{ ['x'] = -555.119140625, ['y'] = -786.57287597656, ['z'] = 30.698328018188}, 
	{ ['x'] = -550.49890136719, ['y'] = -792.15960693359, ['z'] = 29.421474456787}, 
	{ ['x'] = -548.03894042969, ['y'] = -787.85656738281, ['z'] = 29.315540313721}, 
	{ ['x'] = -316.58715820312, ['y'] = -1084.7517089844, ['z'] = 30.385091781616}, 
	{ ['x'] = -307.85531616211, ['y'] = -1088.8168945312, ['z'] = 30.385065078735}, 
	{ ['x'] = -302.01873779297, ['y'] = -1087.6602783203, ['z'] = 30.384923934937}, 
	{ ['x'] = -301.20654296875, ['y'] = -1080.4995117188, ['z'] = 30.385105133057}, 
	{ ['x'] = -307.10885620117, ['y'] = -1076.8596191406, ['z'] = 30.385589599609}, 
	{ ['x'] = -316.7939453125, ['y'] = -1075.9884033203, ['z'] = 30.384645462036}, 
	{ ['x'] = -318.47323608398, ['y'] = -1082.0075683594, ['z'] = 30.385108947754}, 
	{ ['x'] = -129.44230651855, ['y'] = -1582.2137451172, ['z'] = 34.219261169434}, 
	{ ['x'] = -129.31767272949, ['y'] = -1591.6733398438, ['z'] = 34.211875915527}, 
	{ ['x'] = -122.4930267334, ['y'] = -1584.1124267578, ['z'] = 34.210559844971}, 
	{ ['x'] = -128.52922058105, ['y'] = -1584.5838623047, ['z'] = 32.281848907471}, 
	{ ['x'] = -130.36164855957, ['y'] = -1588.7260742188, ['z'] = 32.28205871582}, 
	{ ['x'] = -91.523170471191, ['y'] = -1621.5437011719, ['z'] = 29.560691833496}, 
	{ ['x'] = -87.561592102051, ['y'] = -1616.6571044922, ['z'] = 29.560691833496}, 
	{ ['x'] = -85.34725189209, ['y'] = -1614.0701904297, ['z'] = 31.484136581421}, 
	{ ['x'] = -85.067237854004, ['y'] = -1619.4681396484, ['z'] = 31.481508255005}, 
	{ ['x'] = -93.626068115234, ['y'] = -1618.0765380859, ['z'] = 31.48553276062}, 
	{ ['x'] = 960.07238769531, ['y'] = -686.45092773438, ['z'] = 57.466300964355}, 
	{ ['x'] = 950.84899902344, ['y'] = -687.7734375, ['z'] = 57.418495178223}, 
	{ ['x'] = 951.17767333984, ['y'] = -694.64642333984, ['z'] = 57.468318939209}, 
	{ ['x'] = 919.08441162109, ['y'] = -655.34368896484, ['z'] = 57.914794921875}, 
	{ ['x'] = 911.62908935547, ['y'] = -652.54089355469, ['z'] = 57.909652709961}, 
	{ ['x'] = 912.80169677734, ['y'] = -657.41717529297, ['z'] = 57.910102844238}, 
	{ ['x'] = 905.08361816406, ['y'] = -640.09301757812, ['z'] = 58.07540512085}, 
	{ ['x'] = 895.09356689453, ['y'] = -637.11437988281, ['z'] = 58.062229156494}, 
	{ ['x'] = 899.26062011719, ['y'] = -644.17681884766, ['z'] = 58.069469451904}, 
	{ ['x'] = 880.06671142578, ['y'] = -620.06512451172, ['z'] = 58.219467163086}, 
	{ ['x'] = 877.38165283203, ['y'] = -612.15270996094, ['z'] = 58.291931152344}, 
	{ ['x'] = 871.61419677734, ['y'] = -613.85357666016, ['z'] = 58.297996520996}, 
	{ ['x'] = 840.39471435547, ['y'] = -581.85223388672, ['z'] = 57.215759277344}, 
	{ ['x'] = 834.75793457031, ['y'] = -578.36413574219, ['z'] = 57.117824554443}, 
	{ ['x'] = 839.38146972656, ['y'] = -575.54016113281, ['z'] = 57.118812561035}, 
	{ ['x'] = 829.33898925781, ['y'] = -531.96038818359, ['z'] = 56.426193237305}, 
	{ ['x'] = 822.31365966797, ['y'] = -532.87969970703, ['z'] = 56.423324584961}, 
	{ ['x'] = 821.16668701172, ['y'] = -525.16693115234, ['z'] = 56.423313140869}, 
	{ ['x'] = 826.80596923828, ['y'] = -519.54626464844, ['z'] = 56.469390869141}, 
	{ ['x'] = 828.72814941406, ['y'] = -528.21411132812, ['z'] = 56.423309326172}, 
	{ ['x'] = 847.49914550781, ['y'] = -506.33926391602, ['z'] = 56.295372009277}, 
	{ ['x'] = 848.58551025391, ['y'] = -503.66439819336, ['z'] = 54.837074279785}, 
	{ ['x'] = 850.2548828125, ['y'] = -498.94027709961, ['z'] = 54.836006164551}, 
	{ ['x'] = 853.15643310547, ['y'] = -497.47479248047, ['z'] = 56.778617858887}, 
	{ ['x'] = 844.15771484375, ['y'] = -500.83792114258, ['z'] = 56.775157928467}, 
	{ ['x'] = 888.77612304688, ['y'] = -470.20495605469, ['z'] = 58.388866424561}, 
	{ ['x'] = 897.74206542969, ['y'] = -471.67211914062, ['z'] = 59.015808105469}, 
	{ ['x'] = 892.08038330078, ['y'] = -472.94598388672, ['z'] = 59.015228271484}, 
	{ ['x'] = 911.92834472656, ['y'] = -460.63891601562, ['z'] = 60.553985595703}, 
	{ ['x'] = 916.01190185547, ['y'] = -456.00375366211, ['z'] = 60.55330657959}, 
	{ ['x'] = 921.18408203125, ['y'] = -457.89028930664, ['z'] = 60.704158782959}, 
	{ ['x'] = 916.55072021484, ['y'] = -462.93966674805, ['z'] = 60.710422515869}, 
	{ ['x'] = 931.86218261719, ['y'] = -451.21499633789, ['z'] = 61.250301361084}, 
	{ ['x'] = 939.67608642578, ['y'] = -442.73049926758, ['z'] = 61.250308990479}, 
	{ ['x'] = 933.21533203125, ['y'] = -443.62854003906, ['z'] = 61.250255584717}, 
	{ ['x'] = 956.27850341797, ['y'] = -443.74353027344, ['z'] = 62.600170135498}, 
	{ ['x'] = 954.59637451172, ['y'] = -436.99526977539, ['z'] = 62.48942565918}, 
	{ ['x'] = 950.41052246094, ['y'] = -435.64117431641, ['z'] = 62.497707366943}, 
	{ ['x'] = 950.64465332031, ['y'] = -440.68923950195, ['z'] = 62.531360626221}, 
	{ ['x'] = 970.52392578125, ['y'] = -438.5182800293, ['z'] = 63.749725341797}, 
	{ ['x'] = 971.79663085938, ['y'] = -431.69372558594, ['z'] = 63.750431060791}, 
	{ ['x'] = 1005.583984375, ['y'] = -407.95712280273, ['z'] = 64.421775817871}, 
	{ ['x'] = 1008.6282348633, ['y'] = -408.38623046875, ['z'] = 64.541313171387}, 
	{ ['x'] = 1419.3601074219, ['y'] = 1149.9322509766, ['z'] = 114.41137695312}, 
	{ ['x'] = 1419.2719726562, ['y'] = 1157.0112304688, ['z'] = 114.67394256592}, 
	{ ['x'] = 1418.6899414062, ['y'] = 1145.345703125, ['z'] = 114.13653564453}, 
	{ ['x'] = 1547.5251464844, ['y'] = 3822.2834472656, ['z'] = 31.069400787354}, 
	{ ['x'] = 1545.8034667969, ['y'] = 3810.9018554688, ['z'] = 30.099973678589}, 
	{ ['x'] = 1539.6986083984, ['y'] = 3810.3315429688, ['z'] = 32.344310760498}, 
	{ ['x'] = 1554.6380615234, ['y'] = 3816.0895996094, ['z'] = 32.329956054688}, 
	{ ['x'] = 1551.3494873047, ['y'] = 3827.1638183594, ['z'] = 32.33056640625}, 
	{ ['x'] = 1541.5620117188, ['y'] = 3824.0805664062, ['z'] = 32.330757141113}, 
	{ ['x'] = 1567.0601806641, ['y'] = 3571.4829101562, ['z'] = 33.557323455811}, 
	{ ['x'] = 1556.9348144531, ['y'] = 3572.4372558594, ['z'] = 35.320030212402}, 
	{ ['x'] = 1565.1949462891, ['y'] = 3579.8312988281, ['z'] = 35.436622619629}, 
	{ ['x'] = 1580.8336181641, ['y'] = 3581.9992675781, ['z'] = 34.837677001953}, 
	{ ['x'] = 1578.6652832031, ['y'] = 3579.2106933594, ['z'] = 35.638301849365}, 
	{ ['x'] = 1570.6927490234, ['y'] = 3569.7448730469, ['z'] = 35.436687469482}, 
	{ ['x'] = -175.53433227539, ['y'] = 6424.1567382812, ['z'] = 30.550142288208}, 
	{ ['x'] = -171.65707397461, ['y'] = 6418.8583984375, ['z'] = 30.953071594238}, 
	{ ['x'] = -174.56533813476, ['y'] = 6414.1982421875, ['z'] = 31.915933609009}, 
	{ ['x'] = -172.8737487793, ['y'] = 6430.3803710938, ['z'] = 31.915880203247}, 
	{ ['x'] = -2800.0600585938, ['y'] = 1457.8739013672, ['z'] = 100.89277648926}, 
	{ ['x'] = -2792.6208496094, ['y'] = 1453.833984375, ['z'] = 100.94136047363}, 
	{ ['x'] = -2796.8259277344, ['y'] = 1448.0026855469, ['z'] = 100.93448638916}, 

}


for i=1, #Config.Pool, 1 do

	Config.Zones['Pool' .. i] = {
		Pos   = Config.Pool[i],
		Size  = {x = 1.5, y = 1.5, z = 1.0},
		Color = {r = 40, g = 169, b = 255},
		Type  = -1
	}

end

Config.Uniforms = {

	job_wear = {
		male = {
			['tshirt_1'] = 15, ['tshirt_2'] = 0,
			['torso_1'] = 17, ['torso_2'] = 4,
			['decals_1'] = 0, ['decals_2'] = 0,
			['arms'] = 5,
			['pants_1'] = 16, ['pants_2'] = 3,
			['shoes_1'] = 16, ['shoes_2'] = 0,
			['helmet_1'] = 15, ['helmet_2'] = 1,
			['chain_1'] = 0, ['chain_2'] = 0,
			['ears_1'] = -1, ['ears_2'] = 0
		},
		female = {
			['tshirt_1'] = 2, ['tshirt_2'] = 0,
			['torso_1'] = 195, ['torso_2'] = 24,
			['decals_1'] = 0, ['decals_2'] = 0,
			['arms'] = 15,
			['pants_1'] = 16, ['pants_2'] = 11,
			['shoes_1'] = 16, ['shoes_2'] = 4,
			['helmet_1'] = -1, ['helmet_2'] = 0,
			['chain_1'] = 0, ['chain_2'] = 0,
			['ears_1'] = -1, ['ears_2'] = 0
		}
	},
}
