Config                            = {}
Config.DrawDistance               = 20.0
Config.nameJob                    = "works"
Config.nameJobLabel               = "City Works"
Config.platePrefix                = "LSWP"
Config.Locale                     = 'fr'

Config.Vehicles = {
	Truck = {
		Spawner = 1,
		Label = 'LS Water & Power Truck',
		Hash = "boxville",
		Livery = 0,
		Trailer = "none",
	}	
}

Config.Zones = {

  Cloakroom = {
    Pos     = {x = 2463.35, y = -320.50, z = 92.09},
    Size    = {x = 1.5, y = 1.5, z = 0.3},
    Color   = {r = 0, g = 0, b = 255},
    Type    = 1,
	BlipSprite = 354,
	BlipColor = 46,
	BlipName = 'LS Department of Water & Power',
	hint = 'Press ~INPUT_CONTEXT~ to access the job locker',
  },

  VehicleSpawner = {
	Pos   = {x = 2473.95, y = -331.51, z = 91.99},
	Size  = {x = 1.5, y = 1.5, z = 0.3},
	Color = {r = 0, g = 0, b = 255},
	Type  = 1,
	BlipName = Config.nameJobLabel.." : Vehicle",
	hint = 'Press ~INPUT_CONTEXT~ to select a vehicle',
  },

  VehicleSpawnPoint = {
	Pos   = {x = 2484.09, y = -323.77, z = 92.89},
	Size  = {x = 3.0, y = 3.0, z = 1.0},
	Type  = -1,
	Heading = 347.50,
  },

  VehicleDeleter = {
	Pos   = {x = 2484.09, y = -323.77, z = 91.89},
	Size  = {x = 3.0, y = 3.0, z = 0.3},
	Color = {r = 255, g = 0, b = 0},
	Type  = 1,
	BlipName = Config.nameJobLabel.." : Return Vehicle",
	hint = 'Press ~INPUT_CONTEXT~ to return vehicle',
  },

  Vente = {
	Pos   = {x = 2476.87, y = -384.06, z = 93.40},
	Size  = {x = 2.5, y = 2.5, z = 0.3},
	Color = {r = 0, g = 255, b = 0},
	Type  = 1,
	BlipName = Config.nameJobLabel.." : Job Cash Out",

	ItemTime = 500,
	ItemDb_name = "pay_works",
	ItemName = "City Check",
	ItemMax = 45,
	ItemAdd = 1,
	ItemRemove = 1,
	ItemRequires = "pay_works",
	ItemRequires_name = "City Check",
	ItemDrop = 100,
	ItemPrice  = 800,
	hint = 'Press ~INPUT_CONTEXT~ to cash your City Checks',
  },

}

Config.Pool = {

{ [ 'x' ] = 	 738.48		, [ 'y' ] = 	6489.67		, [ 'z' ] = 	26.66	},
{ [ 'x' ] = 	 1304.29	, [ 'y' ] = 	6508.83		, [ 'z' ] = 	20.05	},
{ [ 'x' ] = 	 2501.19	, [ 'y' ] = 	5458.68		, [ 'z' ] = 	44.53	},
{ [ 'x' ] = 	 2585.95	, [ 'y' ] = 	5065.64		, [ 'z' ] = 	44.92	},
{ [ 'x' ] = 	 2836.66	, [ 'y' ] = 	4196.10		, [ 'z' ] = 	50.17	},
{ [ 'x' ] = 	 2858.91	, [ 'y' ] = 	3709.94		, [ 'z' ] = 	48.42	},
{ [ 'x' ] = 	 2517.14	, [ 'y' ] = 	3027.60		, [ 'z' ] = 	42.26	},
{ [ 'x' ] = 	 1719.09	, [ 'y' ] = 	1691.41		, [ 'z' ] = 	81.03	},
{ [ 'x' ] = 	 1076.30	, [ 'y' ] = 	423.74		, [ 'z' ] = 	91.53	},
{ [ 'x' ] = 	 1151.32	, [ 'y' ] = 	383.38		, [ 'z' ] = 	91.41	},
{ [ 'x' ] = 	 274.71		, [ 'y' ] = 	-838.78		, [ 'z' ] = 	29.24	},
{ [ 'x' ] = 	 304.90		, [ 'y' ] = 	-869.71		, [ 'z' ] = 	29.29	},
{ [ 'x' ] = 	 100.93		, [ 'y' ] = 	-969.27		, [ 'z' ] = 	29.37	},
{ [ 'x' ] = 	 -172.42	, [ 'y' ] = 	-914.07		, [ 'z' ] = 	29.30	},
{ [ 'x' ] = 	 -289.49	, [ 'y' ] = 	-1157.72	, [ 'z' ] = 	23.02	},
{ [ 'x' ] = 	 -345.84	, [ 'y' ] = 	-1491.37	, [ 'z' ] = 	30.79	},
{ [ 'x' ] = 	 -415.40	, [ 'y' ] = 	-1781.36	, [ 'z' ] = 	21.27	},
{ [ 'x' ] = 	 -360.67	, [ 'y' ] = 	-1857.71	, [ 'z' ] = 	20.54	},
{ [ 'x' ] = 	 -114.79	, [ 'y' ] = 	-1554.54	, [ 'z' ] = 	33.90	},
{ [ 'x' ] = 	 -36.22		, [ 'y' ] = 	-1576.17	, [ 'z' ] = 	29.29	},
{ [ 'x' ] = 	 -71.57		, [ 'y' ] = 	-1802.43	, [ 'z' ] = 	27.77	},
{ [ 'x' ] = 	 99.75		, [ 'y' ] = 	-1924.24	, [ 'z' ] = 	20.74	},
{ [ 'x' ] = 	 334.79		, [ 'y' ] = 	-1932.80	, [ 'z' ] = 	24.71	},
{ [ 'x' ] = 	 355.73		, [ 'y' ] = 	-2171.11	, [ 'z' ] = 	14.07	},
{ [ 'x' ] = 	 -776.03	, [ 'y' ] = 	-1698.30	, [ 'z' ] = 	29.26	},
{ [ 'x' ] = 	 -904.76	, [ 'y' ] = 	-1781.51	, [ 'z' ] = 	37.37	},
{ [ 'x' ] = 	 -469.08	, [ 'y' ] = 	-2302.44	, [ 'z' ] = 	63.11	},
{ [ 'x' ] = 	 193.46		, [ 'y' ] = 	-3194.00	, [ 'z' ] = 	5.79	},
{ [ 'x' ] = 	 305.07		, [ 'y' ] = 	-3115.05	, [ 'z' ] = 	5.85	},
{ [ 'x' ] = 	 371.47		, [ 'y' ] = 	-2487.27	, [ 'z' ] = 	6.09	},
{ [ 'x' ] = 	 1019.09	, [ 'y' ] = 	-2266.90	, [ 'z' ] = 	30.51	},
{ [ 'x' ] = 	 1452.70	, [ 'y' ] = 	-1893.86	, [ 'z' ] = 	90.91	},
{ [ 'x' ] = 	 1471.78	, [ 'y' ] = 	-1755.72	, [ 'z' ] = 	69.08	},
{ [ 'x' ] = 	 1226.93	, [ 'y' ] = 	-1488.12	, [ 'z' ] = 	35.03	},
{ [ 'x' ] = 	 1244.40	, [ 'y' ] = 	-1475.49	, [ 'z' ] = 	34.90	},
{ [ 'x' ] = 	 1092.56	, [ 'y' ] = 	-794.64		, [ 'z' ] = 	58.27	},
{ [ 'x' ] = 	 830.22		, [ 'y' ] = 	-566.65		, [ 'z' ] = 	57.71	},
{ [ 'x' ] = 	 1167.46	, [ 'y' ] = 	-321.40		, [ 'z' ] = 	69.29	},
{ [ 'x' ] = 	 1917.62	, [ 'y' ] = 	585.99		, [ 'z' ] = 	178.37	},
{ [ 'x' ] = 	 778.55		, [ 'y' ] = 	-390.47		, [ 'z' ] = 	33.37	},
{ [ 'x' ] = 	 22.60		, [ 'y' ] = 	270.32		, [ 'z' ] = 	109.55	},
{ [ 'x' ] = 	 -1673.20	, [ 'y' ] = 	-264.09		, [ 'z' ] = 	51.88	},
{ [ 'x' ] = 	 -1705.91	, [ 'y' ] = 	-559.74		, [ 'z' ] = 	36.65	},
{ [ 'x' ] = 	 -1661.65	, [ 'y' ] = 	-1146.25	, [ 'z' ] = 	13.02	},
{ [ 'x' ] = 	 -960.59	, [ 'y' ] = 	-3059.56	, [ 'z' ] = 	13.94	},
{ [ 'x' ] = 	 -1222.60	, [ 'y' ] = 	-1182.44	, [ 'z' ] = 	7.72	},
{ [ 'x' ] = 	 -916.12	, [ 'y' ] = 	-1523.36	, [ 'z' ] = 	5.03	},
{ [ 'x' ] = 	 -943.56	, [ 'y' ] = 	-708.14		, [ 'z' ] = 	19.91	},
{ [ 'x' ] = 	 -698.33	, [ 'y' ] = 	-917.51		, [ 'z' ] = 	19.21	},
{ [ 'x' ] = 	 121.07		, [ 'y' ] = 	-1020.88	, [ 'z' ] = 	29.36	},
{ [ 'x' ] = 	 197.70		, [ 'y' ] = 	-586.80		, [ 'z' ] = 	29.52	},
{ [ 'x' ] = 	 -2064.52	, [ 'y' ] = 	-312.61		, [ 'z' ] = 	13.26	},
{ [ 'x' ] = 	 -3011.40	, [ 'y' ] = 	234.31		, [ 'z' ] = 	16.32	},
{ [ 'x' ] = 	 -3067.57	, [ 'y' ] = 	784.82		, [ 'z' ] = 	21.36	},
{ [ 'x' ] = 	 -3195.12	, [ 'y' ] = 	949.41		, [ 'z' ] = 	16.59	},
{ [ 'x' ] = 	 -2520.74	, [ 'y' ] = 	2307.97		, [ 'z' ] = 	33.21	},
{ [ 'x' ] = 	 2053.09	, [ 'y' ] = 	3689.79		, [ 'z' ] = 	34.59	},
{ [ 'x' ] = 	 2295.99	, [ 'y' ] = 	2943.90		, [ 'z' ] = 	46.58	},
{ [ 'x' ] = 	 2269.45	, [ 'y' ] = 	3756.33		, [ 'z' ] = 	38.42	},
{ [ 'x' ] = 	 1717.32	, [ 'y' ] = 	4822.47		, [ 'z' ] = 	41.34	},
{ [ 'x' ] = 	 2226.90	, [ 'y' ] = 	4957.15		, [ 'z' ] = 	41.46	},
{ [ 'x' ] = 	 1713.54	, [ 'y' ] = 	6426.50		, [ 'z' ] = 	32.77	},
{ [ 'x' ] = 	 9.27		, [ 'y' ] = 	6221.19		, [ 'z' ] = 	31.47	},
{ [ 'x' ] = 	 -292.75	, [ 'y' ] = 	6023.74		, [ 'z' ] = 	31.53	},
{ [ 'x' ] = 	 -254.59	, [ 'y' ] = 	6478.92		, [ 'z' ] = 	11.42	},
{ [ 'x' ] = 	 189.04		, [ 'y' ] = 	6624.92		, [ 'z' ] = 	31.81	},
{ [ 'x' ] = 	 2622.84	, [ 'y' ] = 	1957.90		, [ 'z' ] = 	29.79	},
{ [ 'x' ] = 	 2462.96	, [ 'y' ] = 	1481.91		, [ 'z' ] = 	36.20	},
{ [ 'x' ] = 	 2553.96	, [ 'y' ] = 	90.32		, [ 'z' ] = 	111.88	},
{ [ 'x' ] = 	 1789.11	, [ 'y' ] = 	-822.89		, [ 'z' ] = 	74.34	},
{ [ 'x' ] = 	 -82.72		, [ 'y' ] = 	-535.78		, [ 'z' ] = 	40.40	},
{ [ 'x' ] = 	 -1355.97	, [ 'y' ] = 	117.83		, [ 'z' ] = 	56.26	},
{ [ 'x' ] = 	 790.78		, [ 'y' ] = 	1269.96		, [ 'z' ] = 	360.30	},
{ [ 'x' ] = 	 760.05		, [ 'y' ] = 	1280.54		, [ 'z' ] = 	360.30	},
{ [ 'x' ] = 	 661.19		, [ 'y' ] = 	1283.88		, [ 'z' ] = 	360.30	},
{ [ 'x' ] = 	 -2232.35	, [ 'y' ] = 	-361.99		, [ 'z' ] = 	13.31	},
{ [ 'x' ] = 	 -1144.74	, [ 'y' ] = 	-511.52		, [ 'z' ] = 	33.65	},
{ [ 'x' ] = 	 -1509.44	, [ 'y' ] = 	-563.27		, [ 'z' ] = 	33.02	},
{ [ 'x' ] = 	 -1182.22	, [ 'y' ] = 	-904.37		, [ 'z' ] = 	13.46	},
{ [ 'x' ] = 	 1100.28	, [ 'y' ] = 	-1288.20	, [ 'z' ] = 	23.32	},
{ [ 'x' ] = 	 1569.03	, [ 'y' ] = 	855.00		, [ 'z' ] = 	77.48	},
{ [ 'x' ] = 	 399.44		, [ 'y' ] = 	2628.99		, [ 'z' ] = 	44.50	},
{ [ 'x' ] = 	 604.59		, [ 'y' ] = 	2784.48		, [ 'z' ] = 	42.22	},
{ [ 'x' ] = 	 699.34		, [ 'y' ] = 	3116.41		, [ 'z' ] = 	44.16	},
{ [ 'x' ] = 	 1182.14	, [ 'y' ] = 	3265.08		, [ 'z' ] = 	39.43	},
{ [ 'x' ] = 	 -1932.09	, [ 'y' ] = 	2038.77		, [ 'z' ] = 	140.83	},
{ [ 'x' ] = 	 -1199.56	, [ 'y' ] = 	-3501.91	, [ 'z' ] = 	14.00	},
{ [ 'x' ] = 	 -1445.40	, [ 'y' ] = 	-3310.26	, [ 'z' ] = 	13.94	},
{ [ 'x' ] = 	 -1744.13	, [ 'y' ] = 	-2785.27	, [ 'z' ] = 	13.94	},
{ [ 'x' ] = 	 364.19		, [ 'y' ] = 	-763.14		, [ 'z' ] = 	29.27	},
{ [ 'x' ] = 	 346.38		, [ 'y' ] = 	-560.82		, [ 'z' ] = 	28.74	},
{ [ 'x' ] = 	 666.58		, [ 'y' ] = 	1212.77		, [ 'z' ] = 	344.31	},
{ [ 'x' ] = 	 730.69		, [ 'y' ] = 	2534.22		, [ 'z' ] = 	73.22	},
{ [ 'x' ] = 	 3604.94	, [ 'y' ] = 	3636.08		, [ 'z' ] = 	41.34	},
{ [ 'x' ] = 	 2998.59	, [ 'y' ] = 	4098.67		, [ 'z' ] = 	56.98	},
{ [ 'x' ] = 	 2943.66	, [ 'y' ] = 	4632.41		, [ 'z' ] = 	48.72	},
{ [ 'x' ] = 	 2872.57	, [ 'y' ] = 	4869.52		, [ 'z' ] = 	62.32	},
{ [ 'x' ] = 	 -165.08	, [ 'y' ] = 	6446.54		, [ 'z' ] = 	31.92	},
{ [ 'x' ] = 	 -777.80	, [ 'y' ] = 	5593.62		, [ 'z' ] = 	33.63	},
{ [ 'x' ] = 	 337.87		, [ 'y' ] = 	3402.43		, [ 'z' ] = 	36.48	},
{ [ 'x' ] = 	 -2379.49	, [ 'y' ] = 	2712.15		, [ 'z' ] = 	3.42	},


}

for i=1, #Config.Pool, 1 do

    Config.Zones['Pool' .. i] = {
        Pos   = Config.Pool[i],
        Size  = {x = 1.5, y = 1.5, z = 1.0},
        Color = {r = 204, g = 204, b = 0},
        Type  = -1
    }

end

Config.Uniforms = {

  job_wear = {
    male = {
        ['tshirt_1'] = 59, ['tshirt_2'] = 0,
		['torso_1'] = 0, ['torso_2'] = 8,
		['decals_1'] = 0, ['decals_2'] = 0,
		['arms'] = 30,
		['pants_1'] = 37, ['pants_2'] = 1,
		['shoes_1'] = 12, ['shoes_2'] = 6,
		['chain_1'] = 0, ['chain_2'] = 0,
		['mask_1'] = 0, ['mask_2'] = 0,
		['bproof_1'] = 0, ['bproof_2'] = 0,
		['mask_1'] = 0, ['mask_2'] = 0,
		['helmet_1'] = 25, ['helmet_2'] = 2,
		['watches_1'] = 20, ['watches_2'] = 0,
		['bracelets_1'] = -1, ['bracelets_2'] = 0,
		['glasses_1'] = 0, ['glasses_2'] = 0,
		['bag'] = 0,
		['ear_accessories'] = 0,
    },
    female = {
        ['tshirt_1'] = 36, ['tshirt_2'] = 0,
		['torso_1'] = 16, ['torso_2'] = 6,
		['decals_1'] = 0, ['decals_2'] = 0,
		['arms'] = 37,
		['pants_1'] = 37, ['pants_2'] = 1,
		['shoes_1'] = 55, ['shoes_2'] = 0,
		['chain_1'] = 0, ['chain_2'] = 0,
		['mask_1'] = 0, ['mask_2'] = 0,
		['bproof_1'] = 0, ['bproof_2'] = 0,
		['mask_1'] = 0, ['mask_2'] = 0,
		['helmet_1'] = 53, ['helmet_2'] = 0,
		['watches_1'] = 20, ['watches_2'] = 0,
		['bracelets_1'] = -1, ['bracelets_2'] = 0,
		['glasses_1'] = 0, ['glasses_2'] = 0,
		['bag'] = 0,
		['ear_accessories'] = 0,
    }
  },
}

