local cfg = {}

cfg.locale = 'ru'

cfg.rotations = {
  {-72.501, 79.501, -150.871},
  {0.0, 0.0, -108.4},
  {0.0, 0.0, -66.201},
  {0.0, 0.0, 179.599},
  {0.0, 0.0, -36.002},
  {-24.634, 101.263, -178.531},
  {0.0, 0.0, -142.331},
  {0.0, 0.0, 86.069},
  {0.0, 0.0, 62.869},
  {-77.337, 0.0, 62.869},
  {0.0, 0.0, 86.069},
  {-0.938, 0.437, -26.769},
  {0.0, 0.0, -111.932},
  {0.0, -3.923, -162.532},
  {0.0, 0.0, 97.7147},
  {0.0, 0.0, -110.836},
  {-45.713, 0.0, 93.164},
  {-85.885, 120.637, -180},
  {0.0, 0.0, 111.4},
  {0.0, 0.0, 86.599},
  {-43.946, 0.0, -111.401},
  {0.0, 0.0, 47.599},
  {-88.249, -180.0, 112.799},
  {0.0, 0.0, 170.998},
  {0.0, 0.0, 111.798},
  {0.0, 0.0, 74.598},
  {0.0, 0.0, 137.597},
  {0.0, 0.0, 155.797},
  {-21.498, 0.0, 155.797},
  {0.0, 0.0, -111.203},
  {0.0, 0.0, 158.597},
  {-83.123, 0.0, -120.203},
  {0.0, 0.0, -39.603},
  {0.0, 90.157, 19.797},
  {0.0, 0.0, -9.403},
  {0.0, 0.0, -27.603},
  {0.0, 0.0, 173.396},
  {-87.131, -180.0, -50.604},
  {0.0, 0.0, 113.396},
  {0.0, 0.0, -105.804},
  {-45.53, 0.0, 86.795},
  {-74.997, 0.0, 67.595},
  {0.0, 0.0, 91.595},
  {0.0, 92.382, -149.405},
  {0.0, 0.0, 19.595},
  {0.0, 0.0, 8.129},
  {5.231, 0.0, -122.071},
  {-59.897, 0.0, 132.329},
  {0.0, 0.0, -89.672},
  {0.0, 0.0, 45.528},
  {0.0, 0.0, -56.473},
  {0.0, 0.0, 42.727},
  {0.0, 0.0, -74.873},
  {0.0, 0.0, -141.073},
  {0.0, 0.0, -52.873},
  {0.0, 0.0, 89.726},
  {-82.457, 89.968, 177.526},
  {0.0, 0.0, 77.126},
  {0.0, 0.0, -56.074},
  {0.0, 0.0, 99.925},
  {0.0, 0.0, -136.875},
  {0.0, 0.0, 158.125},
  {-74.779, -5.132, 75.389},
  {-60.037, -3.275, 120.688},
  {-87.314, -180.0, -10.112},
  {0.0, 0.0, -158.312},
  {0.0, 0.0, 5.888},
  {0.0, 0.0, -104.512},
  {0.0, 0.0, -155.112},
  {-46.429, 0.0, -17.519},
  {0.0, 0.0, 57.0805},
  {0.0, 0.0, 64.281},
  {0.0, 0.0, -14.919},
  {-87.096, -180.0, 75.281},
  {69.193, 111.118, -85.059},
  {6.063, 3.703, -85.059},
  {0.0, 0.0, -130.06},
  {0.0, 0.0, 97.74},
  {0.0, 0.0, -66.26},
  {0.0, 0.0, 35.94},
  {0.0, 0.0, 69.9999},
  {0.0, 0.0, 146.1993},
  {-86.0052, 0.0, -51.0005},
  {0.0, -13.103, 9.607},
  {0.0, -49.279, -63.1121},
  {-83.014, 0.0, -36.5122},
  {-24.613, 0.0, -4.1123},
  {0.0, 0.0, -52.3123},
  {0.0, 0.0, 25.6875},
  {0.0, 0.0, -11.5121},
  {-12.0161, 0.0, 100.6874},
  {-82.841, 0.0, 100.6874},
  {0.0, 0.0, 173.2871},
  {0.0, 0.0, 129.9366},
  {0.0, -32.4001, 177.3364},
  {-21.0109, -28.2841, 10.1365},
  {-4.501, -41.559, -147.2637},
  {0.0, 0.0, 21.5362},
  {0.0, 0.0, -86.6639},
  {-4.905, 11.395, 175.536},
}

cfg.coords = {
  {-2557.405, 2315.502, 33.742},
  {2487.128, 3759.327, 42.317},
  {457.198, 5573.861, 780.184},
  {-1280.407, 2549.743, 17.534},
  {-107.722, -856.981, 38.261},
  {-1050.513, -522.612, 36.634},
  {693.306, 1200.583, 344.524},
  {2500.654, -389.482, 94.245},
  {483.4, -3110.621, 6.627},
  {-2169.277, 5192.986, 16.295},
  {177.674, 6394.054, 31.376},
  {2416.942, 4994.557, 45.239},
  {1702.9, 3291.0, 48.72},
  {-600.813, 2088.011, 132.336},
  {-3019.793, 41.9486, 10.2924},
  {-485.4648, -54.441, 38.9945},
  {-1350.785, -1547.089, 4.675},
  {379.535, -1509.398, 29.34},
  {2548.713, 385.386, 108.423},
  {-769.346, 877.307, 203.424},
  {-1513.54, 1517.184, 111.305},
  {-1023.899, 190.912, 61.282},
  {1136.355, -666.404, 57.044},
  {3799.76, 4473.048, 6.032},
  {1243.588, -2572.136, 42.603},
  {219.811, 97.162, 96.336},
  {-1545.826, -449.397, 40.318},
  {-928.683, -2938.691, 13.059},
  {-1647.926, -1094.716, 12.736},
  {-2185.939, 4249.814, 48.803},
  {-262.339, 4729.229, 137.329},
  {-311.701, 6315.024, 31.978},
  {3306.444, 5194.742, 17.432},
  {1389.886, 3608.834, 35.06},
  {852.846, 2166.327, 52.717},
  {-1501.96, 814.071, 181.433},
  {2634.972, 2931.061, 44.608},
  {660.57, 549.947, 129.157},
  {-710.626, -905.881, 19.015},
  {1207.701, -1479.537, 35.166},
  {-90.151, 939.849, 232.515},
  {-180.059, -631.866, 48.534},
  {-299.634, 2847.173, 55.485},
  {621.365, -409.254, -1.308},
  {-988.92, -102.669, 40.157},
  {63.999, 3683.868, 39.763},
  {-688.668, 5829.006, 16.775},
  {1540.435, 6323.453, 23.519},
  {2725.806, 4142.14, 43.293},
  {1297.977, 4306.744, 37.897},
  {1189.579, 2641.222, 38.413},
  {-440.796, 1596.48, 358.648},
  {-2237.557, 249.282, 175.352},
  {-1211.932, -959.965, 0.393},
  {153.845, -3077.341, 6.744},
  {-66.231, -1451.825, 31.164},
  {987.982, -136.863, 73.454},
  {-507.032, 393.905, 96.411},
  {172.1275, -564.1393, 22.145},
  {1497.202, -2133.147, 76.302},
  {-2958.706, 386.41, 14.434},
  {1413.963, 1162.483, 114.351},
  {-1648.058, 3018.313, 31.25},
  {-1120.2, 4977.292, 185.445},
  {1310.683, 6545.917, 4.798},
  {1714.573, 4790.844, 41.539},
  {1886.644, 3913.758, 32.039},
  {543.476, 3074.79, 40.324},
  {1408.045, 2157.34, 97.575},
  {-3243.858, 996.179, 12.486},
  {-1905.566, -709.6311, 8.766},
  {-1462.089, 182.089, 54.953},
  {86.997, 812.619, 211.062},
  {-886.554, -2096.579, 8.699},
  {367.684, -2113.475, 16.274},
  {679.009, -1522.824, 8.834},
  {1667.377, 0.119, 165.118},
  {-293.486, -342.485, 9.481},
  {462.664, -765.675, 26.358},
  {-57.784, 1939.74, 189.655},
  {2618.411, 1692.395, 31.9462},
  {-1894.554, 2043.517, 140.9093},
  {2221.858, 5612.785, 54.0631},
  {-551.3712, 5330.728, 73.9861},
  {-2171.406, 3441.188, 32.175},
  {1848.131, 2700.702, 63.008},
  {-1719.602, -232.886, 54.4441},
  {-55.3785, -2519.755, 7.2875},
  {874.8454, -2163.998, 32.3688},
  {-43.6983, -1747.961, 29.2778},
  {173.324, -1208.43, 29.6564},
  {2936.323, 4620.483, 48.767},
  {3514.655, 3754.687, 34.4766},
  {656.9, -1046.931, 21.5745},
  {-141.1536, 234.8366, 99.0008},
  {-1806.68, 427.6159, 131.765},
  {-908.9565, -1148.917, 2.3868},
  {387.9323, 2570.408, 43.299},
  {2399.505, 3062.746, 53.4703},
  {2394.721, 3062.689, 51.2379},
}

cfg.models = {
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_alien',
  'vw_prop_vw_colle_alien',
  'vw_prop_vw_colle_alien',
  'vw_prop_vw_colle_alien',
  'vw_prop_vw_colle_alien',
  'vw_prop_vw_colle_alien',
  'vw_prop_vw_colle_alien',
  'vw_prop_vw_colle_alien',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_imporage',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_prbubble',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_pogo',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrcomm',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_rsrgeneric',
  'vw_prop_vw_colle_beast',
  'vw_prop_vw_colle_sasquatch',
}

cfg.texts = {
  ['ru'] = {
    collected = 'Коллекционная фигурка собрана',
    collected_all = 'Ты собрал все коллекционные фигурки!'
  },

  ['en'] = {
    collected = 'Collectible Figure collected',
    collected_all = 'You have collected all the collectible figures!'
  }
}

cfg.advanceCount = true -- Advance count, because i was told that it is sometimes duped

-- Sorry but i'm lazy
local pickups = {}
for k,v in pairs(cfg.coords) do
  pickups[k] = {GetHashKey(cfg.models[k]), v, cfg.rotations[k]}
end

-- Initialize players stats
local stats_data = LoadResourceFile(GetCurrentResourceName(), 'stats.json')
local stats = {}
if stats_data then
  stats = json.decode(stats_data)
end

-- Parse stats
if cfg.advanceCount then
  for k,v in pairs(stats) do
    local count = 0
    for i,d in pairs(v.pickups) do
      count = count + 1
    end

    v.count = count
  end
end

-- Parse and get license
local function GetPlayerLicense(ids)
  for _,v in pairs(ids) do
    if string.find(v, 'license') then
      return v
    end
  end

  return false
end

-- Pickup event
RegisterNetEvent('halloween-quest:takePuckup')
AddEventHandler('halloween-quest:takePuckup', function(pickupId)
  local ids = GetPlayerIdentifiers(source)
  local license = GetPlayerLicense(ids)
  local data = stats[license]

  if not data then
    stats[license] = {
      count = 0,
      pickups = {}
    }
  end

  stats[license].pickups[pickupId] = true

  if cfg.advanceCount then
    local count = 0
    for i,d in pairs(stats[license].pickups) do
      count = count + 1
    end

    stats[license].count = count
  else
    stats[license].count = stats[license].count + 1
  end

  if stats[license].count == #cfg.coords then
    TriggerClientEvent('halloween-quest:notify', source, cfg.texts[cfg.locale].collected_all)
    TriggerEvent('halloween-quest:collectedAllFigures', source)
  else
    TriggerClientEvent('halloween-quest:notify', source, cfg.texts[cfg.locale].collected..' ('..stats[license].count..'/'..#cfg.coords..')')
  end

  SaveResourceFile(GetCurrentResourceName(), 'stats.json', json.encode(stats), -1)
end)

-- Player request own data
RegisterNetEvent('halloween-quest:requestData')
AddEventHandler('halloween-quest:requestData', function()
  local ids = GetPlayerIdentifiers(source)
  local license = GetPlayerLicense(ids)
  if license then
    local data = stats[license] or {
      count = 0,
      pickups = {}
    }
    TriggerClientEvent('halloween-quest:receiveData', source, data, pickups)
  else
    print('WHAAAT, PLAYER HAVENT LICENSE, SOURCE: '..source)
  end
end)

-- Example reward event
AddEventHandler('halloween-quest:collectedAllFigures', function(playerSource)
  print('Player collect all figures: '..playerSource)
end)